/*
 * Decompiled with CFR 0.152.
 */
package com.nabto.api;

import android.content.Context;
import android.util.Log;
import com.nabto.api.NabtoAndroidAssetManager;
import com.nabto.api.NabtoApi;
import com.nabto.api.NabtoStatus;
import com.nabto.api.RpcResult;
import com.nabto.api.Session;
import com.nabto.api.UrlResult;
import java.util.Collection;

public class NabtoClient {
    private NabtoAndroidAssetManager assetManager;
    private NabtoApi nabtoApi;
    private Session session;
    private boolean initialized;
    private String email;
    private String password;
    private static int PROBE_NETWORK_TIMEOUT_MILLIS = 2000;

    public NabtoClient(Context context) {
        this.assetManager = new NabtoAndroidAssetManager(context);
        this.nabtoApi = new NabtoApi(this.assetManager);
    }

    public NabtoStatus init(String email, String password) {
        this.email = email;
        this.password = password;
        this.session = this.openSession(email, password);
        NabtoStatus status = this.session.getStatus();
        if ((status == NabtoStatus.UNLOCK_PK_FAILED || status == NabtoStatus.OPEN_CERT_OR_PK_FAILED) && (status = this.createProfile(email, password)) != NabtoStatus.OK) {
            return status;
        }
        this.session = this.openSession(email, password);
        status = this.session.getStatus();
        if (status != NabtoStatus.OK) {
            return status;
        }
        this.initialized = true;
        return status;
    }

    public void pause() {
        this.nabtoApi.closeSession(this.session);
        this.nabtoApi.shutdown();
    }

    public boolean resume() {
        this.startup();
        Object s = null;
        if (this.initialized) {
            this.session = this.openSession(this.email, this.password);
            if (this.session.getStatus() != NabtoStatus.OK) {
                Log.d((String)this.getClass().getSimpleName(), (String)"Failed to resume api");
                return false;
            }
            return true;
        }
        return false;
    }

    public String nabtoVersion() {
        return this.nabtoApi.version();
    }

    private NabtoStatus startup() {
        return this.nabtoApi.startup();
    }

    public Collection<String> getProtocolPrefixes() {
        this.startup();
        return this.nabtoApi.getProtocolPrefixes();
    }

    public Collection<String> getLocalDevices() {
        this.startup();
        return this.nabtoApi.getLocalDevices();
    }

    public NabtoStatus probeNetwork() {
        NabtoStatus status = this.nabtoApi.probeNetwork(PROBE_NETWORK_TIMEOUT_MILLIS, null);
        if (status == NabtoStatus.API_NOT_INITIALIZED && (status = this.startup()) == NabtoStatus.OK) {
            status = this.nabtoApi.probeNetwork(PROBE_NETWORK_TIMEOUT_MILLIS, null);
        }
        return status;
    }

    public Collection<String> getCertificates() {
        this.startup();
        return this.nabtoApi.getCertificates();
    }

    private NabtoStatus createProfile(String email, String password) {
        NabtoStatus status = this.probeNetwork();
        if (status != NabtoStatus.OK) {
            return status;
        }
        status = this.nabtoApi.createProfile(email, password);
        if (status == NabtoStatus.API_NOT_INITIALIZED && (status = this.startup()) == NabtoStatus.OK) {
            status = this.nabtoApi.createProfile(email, password);
        }
        return status;
    }

    public NabtoStatus signup(String email, String password) {
        NabtoStatus status = this.probeNetwork();
        if (status != NabtoStatus.OK) {
            return status;
        }
        status = this.nabtoApi.signup(email, password);
        if (status == NabtoStatus.API_NOT_INITIALIZED && (status = this.startup()) == NabtoStatus.OK) {
            status = this.nabtoApi.signup(email, password);
        }
        return status;
    }

    public NabtoStatus resetAccountPassword(String email) {
        NabtoStatus status = this.probeNetwork();
        if (status != NabtoStatus.OK) {
            return status;
        }
        status = this.nabtoApi.resetAccountPassword(email);
        if (status == NabtoStatus.API_NOT_INITIALIZED && (status = this.startup()) == NabtoStatus.OK) {
            status = this.nabtoApi.resetAccountPassword(email);
        }
        return status;
    }

    private Session openSession(String email, String password) {
        Session session = this.nabtoApi.openSession(email, password);
        if (session.getStatus() == NabtoStatus.API_NOT_INITIALIZED) {
            NabtoStatus status = this.startup();
            if (status != NabtoStatus.OK) {
                return new Session(null, status.toInteger());
            }
            session = this.nabtoApi.openSession(email, password);
        }
        return session;
    }

    public RpcResult rpcSetDefaultInterface(String interfaceDefinition) {
        RpcResult result = this.nabtoApi.rpcSetDefaultInterface(interfaceDefinition, this.session);
        if (result.getStatus() == NabtoStatus.API_NOT_INITIALIZED) {
            NabtoStatus status = this.startup();
            if (status != NabtoStatus.OK) {
                return new RpcResult(null, status.toInteger());
            }
            result = this.nabtoApi.rpcSetDefaultInterface(interfaceDefinition, this.session);
        }
        return result;
    }

    public RpcResult rpcSetInterface(String nabtoHost, String interfaceDefinition) {
        RpcResult result = this.nabtoApi.rpcSetInterface(nabtoHost, interfaceDefinition, this.session);
        if (result.getStatus() == NabtoStatus.API_NOT_INITIALIZED) {
            NabtoStatus status = this.startup();
            if (status != NabtoStatus.OK) {
                return new RpcResult(null, status.toInteger());
            }
            result = this.nabtoApi.rpcSetInterface(nabtoHost, interfaceDefinition, this.session);
        }
        return result;
    }

    public RpcResult rpcInvoke(String nabtoUrl) {
        RpcResult result = this.nabtoApi.rpcInvoke(nabtoUrl, this.session);
        if (result.getStatus() == NabtoStatus.API_NOT_INITIALIZED) {
            NabtoStatus status = this.startup();
            if (status != NabtoStatus.OK) {
                return new RpcResult(null, status.toInteger());
            }
            result = this.nabtoApi.rpcInvoke(nabtoUrl, this.session);
        }
        return result;
    }

    public UrlResult fetchUrl(String nabtoUrl) {
        UrlResult result = this.nabtoApi.fetchUrl(nabtoUrl, this.session);
        if (result.getStatus() == NabtoStatus.API_NOT_INITIALIZED) {
            NabtoStatus status = this.startup();
            if (status != NabtoStatus.OK) {
                return new UrlResult(null, null, status.toInteger());
            }
            result = this.nabtoApi.fetchUrl(nabtoUrl, this.session);
        }
        return result;
    }

    public UrlResult submitPostData(String nabtoUrl, byte[] postData, String postMimeType) {
        UrlResult result = this.nabtoApi.submitPostData(nabtoUrl, postData, postMimeType, this.session);
        if (result.getStatus() == NabtoStatus.API_NOT_INITIALIZED) {
            NabtoStatus status = this.startup();
            if (status != NabtoStatus.OK) {
                return new UrlResult(null, null, status.toInteger());
            }
            result = this.nabtoApi.submitPostData(nabtoUrl, postData, postMimeType, this.session);
        }
        return result;
    }

    public String getSessionToken() {
        return this.nabtoApi.getSessionToken(this.session);
    }
}

