var developmentMode = 0;

function getText(key, args) {
    if (key === "") {
	return "";
    }
    var str = lookup(key);
    if (typeof args === "undefined") {
	return str;
    } else if (args.constructor == Array) {
	return replaceParams(str, args);	
    } else {
	return replaceParams(str, [args]);
    }
}

function lookup(key) {
    return lookupForLang(key, globalLanguage());
}

function lookupForLang(key, lang) {
    // uses globalStrings defined in i18n_gen.js
    if (globalStrings_.hasOwnProperty(key)) {
	if (globalStrings_[key].hasOwnProperty(lang)) {
	    return globalStrings_[key][lang];
	} else {
	    if (developmentMode || lang == "en") {
		return "[Error: No '" + key + "' string for language '" + lang + "']";
	    } else {
		return lookupForLang(key, "en");
	    }
	}
    } else {
	return "[Error: No string with key '" + key + "']";
    }
}

function replaceParams(string, replacements) {
    return string.replace(/\{(\d+)\}/g, function() {
        return replacements[arguments[1]];
    });
}

function dayLong(offset) {
    // not currently used (but invoked from data format lib)
    return dayShort(offset);
}

function dayShort(offset) {
    switch (offset) {
    case 0: return getText("_date_dow_abbrev_sunday");
    case 1: return getText("_date_dow_abbrev_monday");
    case 2: return getText("_date_dow_abbrev_tuesday");
    case 3: return getText("_date_dow_abbrev_wednesday");
    case 4: return getText("_date_dow_abbrev_thursday");
    case 5: return getText("_date_dow_abbrev_friday");
    case 6: return getText("_date_dow_abbrev_saturday");
    default: return "[Error: Bad offset]";
    }
}

function monthLong(offset) {
    // not currently used (but invoked from data format lib)
    return monthShort(offset);
}

function monthShort(offset) {
    switch (offset) {
    case 0: return getText("_date_month_abbrev_january");
    case 1: return getText("_date_month_abbrev_february");
    case 2: return getText("_date_month_abbrev_march");
    case 3: return getText("_date_month_abbrev_april");
    case 4: return getText("_date_month_abbrev_may");
    case 5: return getText("_date_month_abbrev_june");
    case 6: return getText("_date_month_abbrev_july");
    case 7: return getText("_date_month_abbrev_august");
    case 8: return getText("_date_month_abbrev_september");
    case 9: return getText("_date_month_abbrev_october");
    case 10: return getText("_date_month_abbrev_november");
    case 11: return getText("_date_month_abbrev_december");
    default: return "[Error: Bad offset]";
    }
}

function languageString(lang) {
    return lookupForLang("_settings_language_this_lang", lang);
}




