var updatePollTimer;


// kudos to Leopd (http://stackoverflow.com/questions/4009524/change-button-text-jquery-mobile):
(function($) {
    /*
     * Changes the displayed text for a jquery mobile button.
     * Encapsulates the idiosyncracies of how jquery re-arranges the DOM
     * to display a button for either an <a> link or <input type="button">
     */
    $.fn.changeButtonText = function(newText) {
        return this.each(function() {
            $this = $(this);
            if( $this.is('a') ) {
                $('span.ui-btn-text',$this).text(newText);
                return;
            }
            if( $this.is('input') ) {
                $this.val(newText);
                // go up the tree
                var ctx = $this.closest('.ui-btn');
                $('span.ui-btn-text',ctx).text(newText);
                return;
            }
        });
    };
})(jQuery);



function stateToString(state) {
    return "" + state;
}

function progressToString(progress, max) {
    return progress + "/" + max;
}

function abort() {
    $.ajax({
	url: '/poll_update_status_jsonp?action=abort',
	dataType: 'jsonp',
	success: handleStatus,
	error: pollStatus
    });
}

function handleStatus(data) {
    if (data.update_active === "true") {
	var state = parseInt(data.state, 10);
	switch (state) {
	case 0: // starting
	case 1: // detect
	case 2: // get_info
	case 3: // put_app
	case 9: // not_started
	    $("#upd_status").text("Restart your device by briefly pressing the reset button or un-/re-plugging the power cable.");
	    enableAbort();
	    setMaxPollFrequency();
	    break;
	case 4: // transfer
	    // device may start directly in this state
	    $("#upd_status").text("Wrote " + data.progress + " of " + data.max + " bytes");
	    $("#firmware_progress_bar").progressbar('value', ((data.progress * 100) / data.max));
	    enableAbort();
	    setMaxPollFrequency();
	    break;
	case 5: // done
	    $("#upd_status").text("Update successfully completed");
	    $("#progress_pct").text("100 %");
	    $("#firmware_progress_bar").progressbar({ value: 100 });
	    $("#firmware_button").changeButtonText("Back to device");
	    $("#firmware_button").click(function() { window.location = globalDeviceUrl } );
	    stopPoll();
	    break;
	case 6: // error
	    $("#upd_status").text("An error occurred during update");
	    enableRestart();
	    break;
	case 7: // abort
	    $("#upd_status").text("Update was aborted");
	    enableRestart();
	    break;
	case 8: // file_not_found
	    $("#upd_status").text("Firmware file could not be located");
	    enableRestart();
	    break;
	case 10:// device_uptodate
	    // stopped - stop polling
	    $("#upd_status").text("Device is uptodate");
	    enableRestart();
	    $("#back_button").show();
	    break;
	default:
	    alert("Unknown state: " + data.state);
	    break;
	}
    } else {
	$("#upd_status").text("No update currently active");
    }
}

function enableRestart() {
    $("#firmware_button").changeButtonText("Restart");
    $("#firmware_button").unbind();
    $("#firmware_button").click(function() { window.location = window.location.href; } );
    stopPoll();
}

function enableAbort() {
    $("#firmware_button").changeButtonText("Abort");
    $("#firmware_button").unbind();
    $("#firmware_button").click(abort);
}

function setMaxPollFrequency() {
    clearInterval(updatePollTimer);
    updatePollTimer = setInterval(pollStatus, 100);
}

function stopPoll() {
    clearInterval(updatePollTimer);
}

function pollStatus() {
    $.ajax({
	url: '/poll_update_status_jsonp',
	dataType: 'jsonp',
	success: handleStatus,
	error: function() {
	    $("#upd_status").text("An error occurred when checking firmware update status");
	    clearInterval(updatePollTimer);
	}
    });
}

function initFirmwareUpdate() {
    $.ajaxSetup({
	isLocal: true
    });
    $("#firmware_progress_bar").progressbar({ value: 0 });
    $('#firmware_progress_bar').progressbar({
	value: 0,
	change: function(event, ui) {
	    var newVal = $(this).progressbar('option', 'value');
	    $('.pblabel', this).text(newVal.toFixed(0) + ' %');
	}
    });
    updatePollTimer = setInterval(pollStatus, 500);
 }