/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength.converter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import nablarch.common.databind.fixedlength.FieldConfig;
import nablarch.common.databind.fixedlength.FieldConvert;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

@FieldConvert(value=RpadConverter.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface Rpad {
    public char value() default 32;

    public static class RpadConverter
    implements FieldConvert.FieldConverter<Rpad> {
        private char padChar;

        @Published
        public RpadConverter() {
        }

        public RpadConverter(char padChar) {
            this.padChar = padChar;
        }

        @Override
        public void initialize(Rpad annotation) {
            this.padChar = annotation.value();
        }

        @Override
        public Object convertOfRead(FixedLengthDataBindConfig fixedLengthDataBindConfig, FieldConfig fieldConfig, byte[] input) {
            int chopPos;
            String value = StringUtil.toString((byte[])input, (Charset)fixedLengthDataBindConfig.getCharset());
            for (chopPos = value.length() - 1; chopPos >= 0 && value.charAt(chopPos) == this.padChar; --chopPos) {
            }
            return value.substring(0, chopPos + 1);
        }

        @Override
        public byte[] convertOfWrite(FixedLengthDataBindConfig fixedLengthDataBindConfig, FieldConfig fieldConfig, Object output) {
            String value = output != null ? StringUtil.toString((Object)output) : "";
            byte[] paddingChar = StringUtil.getBytes((String)Character.toString(this.padChar), (Charset)fixedLengthDataBindConfig.getCharset());
            ByteBuffer buffer = ByteBuffer.allocate(fieldConfig.getLength());
            buffer.put(StringUtil.getBytes((String)value, (Charset)fixedLengthDataBindConfig.getCharset()));
            while (buffer.position() < buffer.limit()) {
                try {
                    buffer.put(paddingChar);
                }
                catch (BufferOverflowException e) {
                    throw new IllegalArgumentException("length after padding is invalid. expected length " + fieldConfig.getLength() + " but was actual length " + (buffer.position() + paddingChar.length) + '.' + " field_name: " + fieldConfig.getName() + " output value: " + output + " padding_char: " + this.padChar, e);
                }
            }
            return buffer.array();
        }
    }
}

