/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength.converter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import nablarch.common.databind.fixedlength.FieldConfig;
import nablarch.common.databind.fixedlength.FieldConvert;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

@FieldConvert(value=LpadConverter.class)
@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Lpad {
    public char value() default 48;

    public static class LpadConverter
    implements FieldConvert.FieldConverter<Lpad> {
        private char padChar;

        @Published
        public LpadConverter() {
        }

        public LpadConverter(char padChar) {
            this.padChar = padChar;
        }

        @Override
        public void initialize(Lpad annotation) {
            this.padChar = annotation.value();
        }

        @Override
        public Object convertOfRead(FixedLengthDataBindConfig fixedLengthDataBindConfig, FieldConfig fieldConfig, byte[] input) {
            int charPos;
            String value = StringUtil.toString((byte[])input, (Charset)fixedLengthDataBindConfig.getCharset());
            for (charPos = 0; charPos < value.length() && value.charAt(charPos) == this.padChar; ++charPos) {
            }
            return value.substring(charPos);
        }

        @Override
        public byte[] convertOfWrite(FixedLengthDataBindConfig fixedLengthDataBindConfig, FieldConfig fieldConfig, Object output) {
            String strValue = output != null ? StringUtil.toString((Object)output) : "";
            byte[] paddingChar = StringUtil.getBytes((String)Character.toString(this.padChar), (Charset)fixedLengthDataBindConfig.getCharset());
            ByteBuffer buffer = ByteBuffer.allocate(fieldConfig.getLength());
            byte[] value = StringUtil.getBytes((String)strValue, (Charset)fixedLengthDataBindConfig.getCharset());
            while (buffer.position() < fieldConfig.getLength() - value.length) {
                buffer.put(paddingChar);
            }
            try {
                buffer.put(value);
            }
            catch (BufferOverflowException e) {
                throw new IllegalArgumentException("length after padding is invalid. expected length " + fieldConfig.getLength() + " but was actual length " + (buffer.position() + value.length) + '.' + " field_name: " + fieldConfig.getName() + " output value: " + strValue + " padding_char: " + this.padChar, e);
            }
            return buffer.array();
        }
    }
}

