/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength.converter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import nablarch.common.databind.fixedlength.FieldConfig;
import nablarch.common.databind.fixedlength.FieldConvert;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.core.util.annotation.Published;

@FieldConvert(value=BinaryConverter.class)
@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Binary {

    public static class BinaryConverter
    implements FieldConvert.FieldConverter<Binary> {
        @Published
        public BinaryConverter() {
        }

        @Override
        public void initialize(Binary annotation) {
        }

        @Override
        public Object convertOfRead(FixedLengthDataBindConfig fixedLengthDataBindConfig, FieldConfig fieldConfig, byte[] input) {
            return input;
        }

        @Override
        public byte[] convertOfWrite(FixedLengthDataBindConfig fixedLengthDataBindConfig, FieldConfig fieldConfig, Object output) {
            if (output instanceof byte[]) {
                byte[] bytes = (byte[])output;
                if (bytes.length != fieldConfig.getLength()) {
                    throw new IllegalArgumentException("length is invalid. expected length " + fieldConfig.getLength() + " but was actual length " + bytes.length + '.' + " field_name: " + fieldConfig.getName());
                }
                return bytes;
            }
            throw new IllegalArgumentException("output is byte array only.");
        }
    }
}

