/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nablarch.common.databind.fixedlength.FieldConfig;
import nablarch.common.databind.fixedlength.FieldConvert;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.common.databind.fixedlength.LayoutBuilderSupport;
import nablarch.common.databind.fixedlength.RecordConfig;
import nablarch.common.databind.fixedlength.converter.DefaultConverter;
import nablarch.core.util.annotation.Published;

public class SingleLayoutBuilder
extends LayoutBuilderSupport {
    private final List<FieldConfig> fieldConfigList = new ArrayList<FieldConfig>();

    public SingleLayoutBuilder(int length, Charset charset, String lineSeparator, char fillChar) {
        super(length, charset, lineSeparator, fillChar);
    }

    @Override
    @Published
    public SingleLayoutBuilder field(String name, int offset, int length) {
        return this.field(name, offset, length, new DefaultConverter());
    }

    @Override
    @Published
    public SingleLayoutBuilder field(String name, int offset, int length, FieldConvert.FieldConverter converter) {
        this.fieldConfigList.add(new FieldConfig(name, offset, length, converter));
        return this;
    }

    @Override
    @Published
    public FixedLengthDataBindConfig build() {
        this.addFillerFieldConfig(this.fieldConfigList);
        HashMap<String, RecordConfig> recordConfigMap = new HashMap<String, RecordConfig>();
        recordConfigMap.put("single", new RecordConfig("single", this.fieldConfigList));
        this.verifyFile();
        this.verifyRecordConfig(recordConfigMap);
        return new FixedLengthDataBindConfig(this.length, this.charset, this.lineSeparator, this.fillChar, recordConfigMap);
    }
}

