/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nablarch.common.databind.InvalidDataFormatException;
import nablarch.common.databind.fixedlength.FieldConfig;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.common.databind.fixedlength.MultiLayoutConfig;
import nablarch.core.util.StringUtil;

public class FixedLengthReader
implements Closeable {
    private final ReadableByteChannel readableChannel;
    private final FixedLengthDataBindConfig config;
    private Long lineNumber = 0L;

    public FixedLengthReader(InputStream inputStream, FixedLengthDataBindConfig config) {
        this.readableChannel = Channels.newChannel(inputStream);
        this.config = config;
    }

    public ReadRecord readRecord() {
        ByteBuffer buffer = ByteBuffer.allocate(this.config.getLength());
        try {
            Long l = this.lineNumber;
            Long l2 = this.lineNumber = Long.valueOf(this.lineNumber + 1L);
            int readLength = this.readableChannel.read(buffer);
            if (readLength < 0) {
                return null;
            }
            if (readLength != this.config.getLength()) {
                throw new InvalidDataFormatException("last record is short.", this.lineNumber);
            }
            this.skipLineSeparator();
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.config.isMultiLayout()) {
                MultiLayoutConfig multiLayoutConfig = this.config.getMultiLayoutConfig();
                MultiLayoutConfig.RecordName recordName = multiLayoutConfig.getRecordIdentifier().identifyRecordName(buffer.array());
                map.put("recordName", recordName);
                List<FieldConfig> fieldConfigList = this.config.getRecordConfig(recordName.getRecordName()).getFieldConfigList();
                HashMap<String, Object> fields = new HashMap<String, Object>();
                for (FieldConfig fieldConfig : fieldConfigList) {
                    fields.put(fieldConfig.getName(), this.readValue(buffer.array(), this.config, fieldConfig));
                }
                map.put(recordName.getRecordName(), fields);
            } else {
                List<FieldConfig> fieldConfigList = this.config.getRecordConfig("single").getFieldConfigList();
                for (FieldConfig fieldConfig : fieldConfigList) {
                    map.put(fieldConfig.getName(), this.readValue(buffer.array(), this.config, fieldConfig));
                }
            }
            return new ReadRecord(map, this.lineNumber);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void skipLineSeparator() throws IOException {
        if (StringUtil.isNullOrEmpty((String)this.config.getLineSeparator())) {
            return;
        }
        int length = this.config.getLineSeparator().length();
        ByteBuffer buffer = ByteBuffer.allocate(length);
        int readLength = this.readableChannel.read(buffer);
        if (readLength == -1) {
            return;
        }
        if (readLength != length) {
            throw new InvalidDataFormatException("line separator is invalid.", this.lineNumber);
        }
        if (!new String(buffer.array(), this.config.getCharset()).equals(this.config.getLineSeparator())) {
            throw new InvalidDataFormatException("line separator is invalid.", this.lineNumber);
        }
    }

    public Object readValue(byte[] record, FixedLengthDataBindConfig fixedLengthDataBindConfig, FieldConfig fieldConfig) {
        int zeroOffset = fieldConfig.getOffset() - 1;
        byte[] fieldValue = Arrays.copyOfRange(record, zeroOffset, zeroOffset + fieldConfig.getLength());
        return fieldConfig.getFieldConverter().convertOfRead(fixedLengthDataBindConfig, fieldConfig, fieldValue);
    }

    @Override
    public void close() throws IOException {
        this.readableChannel.close();
    }

    static class ReadRecord {
        private final long lineNumber;
        private final Map<String, Object> data;

        ReadRecord(Map<String, Object> data, long lineNumber) {
            this.data = data;
            this.lineNumber = lineNumber;
        }

        long getLineNumber() {
            return this.lineNumber;
        }

        Map<String, Object> getData() {
            return this.data;
        }
    }
}

