/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength;

import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import nablarch.common.databind.DataBindConfig;
import nablarch.common.databind.DataBindConfigConverter;
import nablarch.common.databind.DataBindUtil;
import nablarch.common.databind.fixedlength.Field;
import nablarch.common.databind.fixedlength.FieldConvert;
import nablarch.common.databind.fixedlength.FixedLength;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfigBuilder;
import nablarch.common.databind.fixedlength.LayoutBuilderSupport;
import nablarch.common.databind.fixedlength.MultiLayout;
import nablarch.common.databind.fixedlength.MultiLayoutBuilder;
import nablarch.common.databind.fixedlength.Record;
import nablarch.common.databind.fixedlength.SingleLayoutBuilder;
import nablarch.common.databind.fixedlength.converter.DefaultConverter;
import nablarch.core.beans.BeansException;

public class FixedLengthDataBindConfigConverter
implements DataBindConfigConverter<FixedLength> {
    @Override
    public DataBindConfig convert(Class<?> beanClass) {
        FixedLength fixedLength = beanClass.getAnnotation(FixedLength.class);
        FixedLengthDataBindConfigBuilder builder = FixedLengthDataBindConfigBuilder.newBuilder().length(fixedLength.length()).charset(Charset.forName(fixedLength.charset())).lineSeparator(fixedLength.lineSeparator()).fillChar(fixedLength.fillChar());
        if (fixedLength.multiLayout()) {
            if (!MultiLayout.class.isAssignableFrom(beanClass)) {
                throw new IllegalStateException("bean class must inherit " + MultiLayout.class.getName() + ". bean_class:" + beanClass.getName());
            }
            MultiLayoutBuilder layoutBuilder = builder.multiLayout().recordIdentifier(((MultiLayout)DataBindUtil.newInstance(beanClass)).getRecordIdentifier());
            for (java.lang.reflect.Field field : beanClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Record.class)) continue;
                layoutBuilder.record(field.getName());
                this.addFields(layoutBuilder, field.getType());
            }
            return layoutBuilder.build();
        }
        SingleLayoutBuilder layoutBuilder = builder.singleLayout();
        this.addFields(layoutBuilder, beanClass);
        return layoutBuilder.build();
    }

    private void addFields(LayoutBuilderSupport layoutBuilder, Class<?> beanClass) {
        for (java.lang.reflect.Field field : beanClass.getDeclaredFields()) {
            Field fieldAnnotation = field.getAnnotation(Field.class);
            if (fieldAnnotation == null) continue;
            FieldConvert.FieldConverter<Annotation> fieldConverter = this.getFieldConverter(field);
            layoutBuilder.field(field.getName(), fieldAnnotation.offset(), fieldAnnotation.length(), fieldConverter == null ? new DefaultConverter() : fieldConverter);
        }
    }

    private FieldConvert.FieldConverter getFieldConverter(java.lang.reflect.Field field) {
        FieldConvert.FieldConverter fieldConverter = null;
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            FieldConvert fieldConvert = annotation.annotationType().getAnnotation(FieldConvert.class);
            if (fieldConvert == null) continue;
            if (fieldConverter != null) {
                throw new IllegalStateException("multiple field converters can not be set. field_name:" + field.getName());
            }
            try {
                fieldConverter = DataBindUtil.newInstance(fieldConvert.value());
            }
            catch (BeansException e) {
                throw new IllegalStateException("instance creation failed. class:" + fieldConvert.value().getName(), e);
            }
            fieldConverter.initialize(annotation);
        }
        return fieldConverter;
    }

    @Override
    public Class<FixedLength> getType() {
        return FixedLength.class;
    }
}

