/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.fixedlength;

import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Map;
import nablarch.common.databind.DataBindUtil;
import nablarch.common.databind.ObjectMapper;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfig;
import nablarch.common.databind.fixedlength.FixedLengthReader;
import nablarch.common.databind.fixedlength.MultiLayoutConfig;
import nablarch.core.beans.BeanUtil;
import nablarch.core.util.FileUtil;
import nablarch.core.util.StringUtil;

public class FixedLengthBeanMapper<T>
implements ObjectMapper<T> {
    private final Class<T> clazz;
    private final FixedLengthDataBindConfig config;
    private final FixedLengthReader reader;
    private final String lineNumberPropertyName;

    public FixedLengthBeanMapper(Class<T> clazz, FixedLengthDataBindConfig config, InputStream stream) {
        this.clazz = clazz;
        this.config = config;
        this.reader = new FixedLengthReader(stream, config);
        this.lineNumberPropertyName = DataBindUtil.findLineNumberProperty(clazz);
    }

    @Override
    public void write(T object) {
        throw new UnsupportedOperationException("unsupported write method.");
    }

    @Override
    public T read() {
        FixedLengthReader.ReadRecord read = this.reader.readRecord();
        if (read == null) {
            return null;
        }
        T bean = this.createBean(read.getData());
        if (StringUtil.hasValue((String)this.lineNumberPropertyName)) {
            BeanUtil.setProperty(bean, (String)this.lineNumberPropertyName, (Object)read.getLineNumber());
        }
        return bean;
    }

    private T createBean(Map<String, ?> read) {
        if (this.config.isMultiLayout()) {
            Object bean = BeanUtil.createAndCopy(this.clazz, read);
            MultiLayoutConfig.RecordName recordName = (MultiLayoutConfig.RecordName)read.get("recordName");
            PropertyDescriptor descriptor = BeanUtil.getPropertyDescriptor(this.clazz, (String)recordName.getRecordName());
            Object record = BeanUtil.createAndCopy(descriptor.getPropertyType(), (Map)((Map)read.get(recordName.getRecordName())));
            BeanUtil.setProperty((Object)bean, (String)recordName.getRecordName(), (Object)record);
            return (T)bean;
        }
        return (T)BeanUtil.createAndCopy(this.clazz, read);
    }

    @Override
    public void close() {
        FileUtil.closeQuietly((Closeable[])new Closeable[]{this.reader});
    }
}

