/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind.csv;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import nablarch.common.databind.InvalidDataFormatException;
import nablarch.common.databind.csv.CsvDataBindConfig;
import nablarch.common.databind.csv.CsvObjectMapperSupport;

public class CsvMapMapper
extends CsvObjectMapperSupport<Map<String, ?>> {
    public CsvMapMapper(CsvDataBindConfig config, InputStream inputStream) {
        this(config, new InputStreamReader(inputStream, config.getCharset()));
    }

    public CsvMapMapper(CsvDataBindConfig config, Reader reader) {
        super(config, reader);
        this.readHeader();
    }

    @Override
    protected Map<String, ?> createObject(String[] record) {
        this.verifyFieldCount(record);
        return this.createMap(record);
    }

    private Map<String, String> createMap(String[] record) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] keys = this.config.getKeys();
        for (int i = 0; i < record.length; ++i) {
            map.put(keys[i], record[i]);
        }
        return map;
    }

    private void verifyFieldCount(String[] record) {
        if (this.config.getKeys().length != record.length) {
            throw new InvalidDataFormatException("property size does not match. expected field count = [" + this.config.getKeys().length + "]," + " actual field count = [" + record.length + "].", this.reader.getLineNumber());
        }
    }
}

