/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.databind;

import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import nablarch.common.databind.DataBindConfig;
import nablarch.common.databind.DataBindConfigConverter;
import nablarch.common.databind.LineNumber;
import nablarch.common.databind.csv.Csv;
import nablarch.common.databind.csv.CsvDataBindConfigConverter;
import nablarch.common.databind.fixedlength.FixedLengthDataBindConfigConverter;
import nablarch.core.beans.BeanUtil;
import nablarch.core.beans.BeansException;
import nablarch.core.util.annotation.Published;

public final class DataBindUtil {
    private static final List<DataBindConfigConverter<?>> CONVERTERS = Arrays.asList(new CsvDataBindConfigConverter(), new FixedLengthDataBindConfigConverter());
    private static final Map<Class<?>, String[]> CSV_PROPERTY_NAMES_MAP = new WeakHashMap();

    private DataBindUtil() {
    }

    public static synchronized String[] findCsvProperties(Class<?> clazz) {
        String[] propertyNames = CSV_PROPERTY_NAMES_MAP.get(clazz);
        if (propertyNames == null) {
            propertyNames = clazz.getAnnotation(Csv.class).properties();
            CSV_PROPERTY_NAMES_MAP.put(clazz, propertyNames);
        }
        return propertyNames;
    }

    @Published(tag={"architect"})
    public static String findLineNumberProperty(Class<?> clazz) {
        String propertyName = null;
        for (PropertyDescriptor pd : BeanUtil.getPropertyDescriptors(clazz)) {
            if (!DataBindUtil.hasLineNumberProperty(pd)) continue;
            if (propertyName != null) {
                throw new IllegalStateException("line number column should be defined only one. class = [" + clazz.getName() + "]");
            }
            propertyName = pd.getName();
        }
        return propertyName;
    }

    public static <T> DataBindConfig createDataBindConfig(Class<T> clazz) {
        for (DataBindConfigConverter<T> dataBindConfigConverter : CONVERTERS) {
            if (clazz.getAnnotation(dataBindConfigConverter.getType()) == null) continue;
            return dataBindConfigConverter.convert(clazz);
        }
        throw new IllegalStateException(MessageFormat.format("can not find config. class = [{0}]", clazz.getName()));
    }

    @Published(tag={"architect"})
    public static <T> T getInstance(Class<T> clazz, String[] propertyNames, String[] values) {
        T bean = DataBindUtil.newInstance(clazz);
        for (int i = 0; i < values.length; ++i) {
            BeanUtil.setProperty(bean, (String)propertyNames[i], (Object)values[i]);
        }
        return bean;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new BeansException((Throwable)e);
        }
    }

    @Published(tag={"architect"})
    public static <T> T getInstanceWithLineNumber(Class<T> clazz, String[] propertyNames, String[] values, String lineNumberPropertyName, long lineNumber) {
        T bean;
        try {
            bean = clazz.newInstance();
        }
        catch (Exception e) {
            throw new BeansException((Throwable)e);
        }
        for (int i = 0; i < values.length; ++i) {
            BeanUtil.setProperty(bean, (String)propertyNames[i], (Object)values[i]);
        }
        BeanUtil.setProperty(bean, (String)lineNumberPropertyName, (Object)lineNumber);
        return bean;
    }

    private static boolean hasLineNumberProperty(PropertyDescriptor pd) {
        return pd.getReadMethod() != null && pd.getReadMethod().getAnnotation(LineNumber.class) != null;
    }
}

