/*
 * Decompiled with CFR 0.152.
 */
package com.nabinbhandari.android.utils.permissions;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.nabinbhandari.android.utils.permissions.PermissionListener;
import com.nabinbhandari.android.utils.permissions.PermissionRequest;
import java.util.ArrayList;
import java.util.List;

public class Permissions {
    private static List<PermissionRequest> requests = new ArrayList<PermissionRequest>();

    private static PermissionRequest findPermissionRequest(Activity activity, int requestCode) {
        for (PermissionRequest permissionRequest : requests) {
            if (requestCode != permissionRequest.requestCode || !activity.equals(permissionRequest.activity)) continue;
            return permissionRequest;
        }
        return null;
    }

    public static void runPermissionCheck(final Activity activity, final int requestCode, String rationale, final PermissionListener permissionListener, String permission, String ... otherPermissions) {
        if (Build.VERSION.SDK_INT < 23) {
            permissionListener.onPermissionGranted(requestCode);
        } else {
            boolean allPermissionProvided = true;
            final ArrayList<String> unGrantedPermissions = new ArrayList<String>();
            if (activity.checkSelfPermission(permission) == -1) {
                allPermissionProvided = false;
                unGrantedPermissions.add(permission);
            }
            for (String otherPermission : otherPermissions) {
                if (activity.checkSelfPermission(otherPermission) != -1) continue;
                allPermissionProvided = false;
                unGrantedPermissions.add(otherPermission);
            }
            if (allPermissionProvided) {
                permissionListener.onPermissionGranted(requestCode);
            } else {
                boolean rationaleShouldBeShown = false;
                for (String unGrantedPermission : unGrantedPermissions) {
                    if (!activity.shouldShowRequestPermissionRationale(unGrantedPermission)) continue;
                    rationaleShouldBeShown = true;
                    break;
                }
                if (rationaleShouldBeShown) {
                    new AlertDialog.Builder((Context)activity).setTitle((CharSequence)"Permission Required").setMessage((CharSequence)rationale).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            Permissions.requestPermissions(activity, unGrantedPermissions, requestCode, permissionListener);
                        }
                    }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            permissionListener.onPermissionDenied(requestCode);
                        }
                    }).setCancelable(false).create().show();
                } else {
                    Permissions.requestPermissions(activity, unGrantedPermissions, requestCode, permissionListener);
                }
            }
        }
    }

    private static void requestPermissions(Activity activity, List<String> permissions, int requestCode, PermissionListener permissionListener) {
        if (Build.VERSION.SDK_INT < 23) {
            permissionListener.onPermissionGranted(requestCode);
        } else {
            activity.requestPermissions(permissions.toArray(new String[0]), requestCode);
            requests.add(new PermissionRequest(activity, requestCode, permissionListener));
        }
    }

    public static void onRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults) {
        PermissionRequest request = Permissions.findPermissionRequest(activity, requestCode);
        if (request != null) {
            requests.remove(request);
            PermissionListener permissionListener = request.permissionListener;
            boolean allPermissionsGranted = true;
            if (grantResults.length > 0) {
                for (int grantResult : grantResults) {
                    if (grantResult == 0) continue;
                    allPermissionsGranted = false;
                    break;
                }
            }
            if (allPermissionsGranted) {
                permissionListener.onPermissionGranted(requestCode);
            } else {
                Permissions.handlePermissionsSetToNeverAskAgain(activity, permissions, request);
            }
        }
    }

    private static void handlePermissionsSetToNeverAskAgain(final Activity activity, String[] permissions, final PermissionRequest request) {
        if (Build.VERSION.SDK_INT >= 23) {
            for (String permission : permissions) {
                if (activity.shouldShowRequestPermissionRationale(permission)) {
                    Log.e((String)"denied", (String)permission);
                    request.permissionListener.onPermissionDenied(request.requestCode);
                    break;
                }
                if (activity.checkSelfPermission(permission) != 0) {
                    Log.e((String)"set to never ask again", (String)permission);
                    new AlertDialog.Builder((Context)activity).setTitle((CharSequence)"Permission Required").setMessage((CharSequence)"Permission forcefully denied! Please provide permissions from settings.").setPositiveButton((CharSequence)"Settings", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)activity.getPackageName(), null));
                            intent.addFlags(0x10000000);
                            activity.startActivity(intent);
                        }
                    }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            request.permissionListener.onPermissionDenied(request.requestCode);
                        }
                    }).setCancelable(false).create().show();
                    break;
                }
                Log.e((String)"allowed", (String)permission);
            }
        }
    }
}

