/*
 * Decompiled with CFR 0.152.
 */
package com.nabinbhandari.android.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.nabinbhandari.android.permissions.PermissionHandler;
import com.nabinbhandari.android.permissions.Permissions;
import java.util.ArrayList;

@TargetApi(value=23)
public class PermissionsActivity
extends Activity {
    private static final int RC_SETTINGS = 6739;
    private static final int RC_PERMISSION = 6937;
    static final String EXTRA_PERMISSIONS = "permissions";
    static final String EXTRA_RATIONALE = "rationale";
    static PermissionHandler permissionHandler;
    private boolean cleanHandlerOnDestroy = true;
    private ArrayList<String> allPermissions;
    private ArrayList<String> deniedPermissions;
    private ArrayList<String> noRationaleList;

    @TargetApi(value=23)
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (intent == null || !intent.hasExtra(EXTRA_PERMISSIONS)) {
            this.finish();
            return;
        }
        this.getWindow().setStatusBarColor(0);
        this.allPermissions = (ArrayList)intent.getSerializableExtra(EXTRA_PERMISSIONS);
        this.deniedPermissions = new ArrayList();
        this.noRationaleList = new ArrayList();
        boolean noRationale = true;
        for (String permission : this.allPermissions) {
            if (this.checkSelfPermission(permission) == 0) continue;
            this.deniedPermissions.add(permission);
            if (this.shouldShowRequestPermissionRationale(permission)) {
                noRationale = false;
                continue;
            }
            this.noRationaleList.add(permission);
        }
        String rationale = intent.getStringExtra(EXTRA_RATIONALE);
        if (noRationale || TextUtils.isEmpty((CharSequence)rationale)) {
            Permissions.log("No rationale.");
            this.requestPermissions(this.deniedPermissions.toArray(new String[0]), 6937);
        } else {
            Permissions.log("Show rationale.");
            this.showRationale(rationale);
        }
    }

    private void showRationale(String rationale) {
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == -1) {
                    PermissionsActivity.this.requestPermissions(PermissionsActivity.this.deniedPermissions.toArray(new String[0]), 6937);
                } else {
                    PermissionsActivity.this.deny();
                }
            }
        };
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)Permissions.dialogTitle).setMessage((CharSequence)rationale).setPositiveButton(17039370, listener).setNegativeButton(0x1040000, listener).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                PermissionsActivity.this.deny();
            }
        }).create().show();
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (grantResults.length == 0) {
            this.deny();
        } else {
            this.deniedPermissions.clear();
            for (int i = 0; i < grantResults.length; ++i) {
                if (grantResults[i] == 0) continue;
                this.deniedPermissions.add(permissions[i]);
            }
            if (this.deniedPermissions.size() == 0) {
                Permissions.log("Just allowed.");
                this.grant();
            } else {
                ArrayList<String> blockedList = new ArrayList<String>();
                ArrayList<String> justBlockedList = new ArrayList<String>();
                ArrayList<String> justDeniedList = new ArrayList<String>();
                for (String permission : this.deniedPermissions) {
                    if (this.shouldShowRequestPermissionRationale(permission)) {
                        justDeniedList.add(permission);
                        continue;
                    }
                    blockedList.add(permission);
                    if (this.noRationaleList.contains(permission)) continue;
                    justBlockedList.add(permission);
                }
                if (justBlockedList.size() > 0) {
                    if (permissionHandler != null) {
                        permissionHandler.onJustBlocked((Context)this, justBlockedList, this.deniedPermissions);
                    }
                    this.finish();
                } else if (justDeniedList.size() > 0) {
                    this.deny();
                } else if (permissionHandler != null && !permissionHandler.onBlocked((Context)this, blockedList)) {
                    this.sendToSettings();
                } else {
                    this.finish();
                }
            }
        }
    }

    private void sendToSettings() {
        if (!Permissions.sendSetNotToAskAgainToSettings) {
            this.deny();
            return;
        }
        Permissions.log("Ask to go to settings.");
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)Permissions.dialogTitle).setMessage((CharSequence)Permissions.forceDeniedDialogMessage).setPositiveButton((CharSequence)Permissions.settingsText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)PermissionsActivity.this.getPackageName(), null));
                PermissionsActivity.this.startActivityForResult(intent, 6739);
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PermissionsActivity.this.deny();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                PermissionsActivity.this.deny();
            }
        }).create().show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 6739 && permissionHandler != null) {
            String first = this.allPermissions.get(0);
            if (this.allPermissions.size() == 0) {
                Permissions.runPermissionCheck((Context)this, null, permissionHandler, first, new String[0]);
            } else {
                ArrayList<String> all = new ArrayList<String>(this.allPermissions);
                all.remove(0);
                Permissions.runPermissionCheck((Context)this, null, permissionHandler, first, all.toArray(new String[0]));
            }
            this.cleanHandlerOnDestroy = false;
        }
        this.finish();
    }

    protected void onDestroy() {
        if (this.cleanHandlerOnDestroy) {
            permissionHandler = null;
        }
        super.onDestroy();
    }

    private void deny() {
        if (permissionHandler != null) {
            permissionHandler.onDenied((Context)this, this.deniedPermissions);
        }
        this.finish();
    }

    private void grant() {
        if (permissionHandler != null) {
            permissionHandler.onGranted();
        }
        this.finish();
    }
}

