/*
 * Decompiled with CFR 0.152.
 */
package com.nabinbhandari.android.permissions;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.nabinbhandari.android.permissions.PermissionHandler;
import com.nabinbhandari.android.permissions.PermissionsActivity;
import java.util.ArrayList;
import java.util.Collections;

public class Permissions {
    public static String dialogTitle = "Permission Required";
    public static boolean sendSetNotToAskAgainToSettings = true;
    public static String settingsText = "Settings";
    public static String forceDeniedDialogMessage = "Required permission(s) have been set not to ask again! Please provide them from settings.";
    public static boolean showLogs = true;

    public static void runPermissionCheck(Context context, String rationale, PermissionHandler permissionHandler, String permission, String ... otherPermissions) {
        if (Build.VERSION.SDK_INT < 23) {
            permissionHandler.onGranted();
            Permissions.log("Android version < 23");
        } else {
            ArrayList<String> permissions = new ArrayList<String>();
            permissions.add(permission);
            Collections.addAll(permissions, otherPermissions);
            boolean allPermissionProvided = true;
            for (String aPermission : permissions) {
                if (context.checkSelfPermission(aPermission) == 0) continue;
                allPermissionProvided = false;
                break;
            }
            if (allPermissionProvided) {
                permissionHandler.onGranted();
                Permissions.log("Permission(s) " + (PermissionsActivity.permissionHandler == null ? "already granted." : "just granted from settings."));
                PermissionsActivity.permissionHandler = null;
            } else {
                PermissionsActivity.permissionHandler = permissionHandler;
                Intent intent = new Intent(context, PermissionsActivity.class);
                intent.putExtra("permissions", permissions);
                intent.putExtra("rationale", rationale);
                context.startActivity(intent);
            }
        }
    }

    static void log(String message) {
        if (showLogs) {
            Log.d((String)"Permissions", (String)message);
        }
    }
}

