/*
 * Decompiled with CFR 0.152.
 */
package com.nabinbhandari.android.permissions;

import android.content.Context;
import android.widget.Toast;
import com.nabinbhandari.android.permissions.Permissions;
import java.util.ArrayList;

public abstract class PermissionHandler {
    public abstract void onGranted();

    public void onDenied(Context context, ArrayList<String> deniedPermissions) {
        if (Permissions.showLogs) {
            StringBuilder builder = new StringBuilder();
            builder.append("Denied:");
            for (String permission : deniedPermissions) {
                builder.append(" ");
                builder.append(permission);
            }
            Permissions.log(builder.toString());
        }
        Toast.makeText((Context)context, (CharSequence)"Permission Denied.", (int)0).show();
    }

    public boolean onBlocked(Context context, ArrayList<String> blockedList) {
        if (Permissions.showLogs) {
            StringBuilder builder = new StringBuilder();
            builder.append("Set not to ask again:");
            for (String permission : blockedList) {
                builder.append(" ");
                builder.append(permission);
            }
            Permissions.log(builder.toString());
        }
        return false;
    }

    public void onJustBlocked(Context context, ArrayList<String> justBlockedList, ArrayList<String> deniedPermissions) {
        if (Permissions.showLogs) {
            StringBuilder builder = new StringBuilder();
            builder.append("Just set not to ask again:");
            for (String permission : justBlockedList) {
                builder.append(" ");
                builder.append(permission);
            }
            Permissions.log(builder.toString());
        }
        this.onDenied(context, deniedPermissions);
    }
}

