/*
 * Decompiled with CFR 0.152.
 */
package com.nabinbhandari.android.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import com.nabinbhandari.android.permissions.PermissionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Permissions
extends Activity {
    public static String dialogTitle = "Permission Required";
    public static String settingsText = "Settings";
    public static String forceDeniedDialogMessage = "Required permission(s) have been set not to ask again! Please provide them from settings.";
    public static boolean recheckPermissionsAfterSettings = true;
    private static final int RC_SETTINGS = 6739;
    private static final int RC_PERMISSION = 6937;
    private static final String TAG = "Permissions";
    private static final String EXTRA_PERMISSIONS = "extra_permissions";
    private static boolean cleanHandlerOnDestroy = true;
    private static PermissionHandler permissionHandler;
    private String[] permissions;

    public static void runPermissionCheck(final Activity activity, String rationale, final PermissionHandler permissionHandler, String permission, String ... otherPermissions) {
        if (Build.VERSION.SDK_INT < 23) {
            permissionHandler.onGranted();
            Log.d((String)TAG, (String)"Android version < 23");
        } else {
            boolean allPermissionProvided = true;
            final ArrayList<String> deniedPermissions = new ArrayList<String>();
            if (activity.checkSelfPermission(permission) != 0) {
                allPermissionProvided = false;
                deniedPermissions.add(permission);
            }
            for (String otherPermission : otherPermissions) {
                if (activity.checkSelfPermission(otherPermission) == 0) continue;
                allPermissionProvided = false;
                deniedPermissions.add(otherPermission);
            }
            if (allPermissionProvided) {
                permissionHandler.onGranted();
                Log.d((String)TAG, (String)"Permission(s) already granted.");
            } else {
                boolean rationaleShouldBeShown = false;
                if (TextUtils.isEmpty((CharSequence)rationale)) {
                    rationaleShouldBeShown = false;
                } else {
                    for (String unGrantedPermission : deniedPermissions) {
                        if (!activity.shouldShowRequestPermissionRationale(unGrantedPermission)) continue;
                        rationaleShouldBeShown = true;
                        break;
                    }
                }
                if (rationaleShouldBeShown) {
                    new AlertDialog.Builder((Context)activity).setTitle((CharSequence)dialogTitle).setMessage((CharSequence)rationale).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            Permissions.requestPermissions(activity, deniedPermissions, permissionHandler);
                        }
                    }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            permissionHandler.onDenied((Context)activity, deniedPermissions);
                        }
                    }).setCancelable(false).create().show();
                } else {
                    Permissions.requestPermissions(activity, deniedPermissions, permissionHandler);
                }
            }
        }
    }

    @TargetApi(value=23)
    private static void requestPermissions(Activity activity, List<String> permissions, PermissionHandler permissionHandler) {
        cleanHandlerOnDestroy = false;
        Permissions.permissionHandler = permissionHandler;
        Intent intent = new Intent((Context)activity, Permissions.class);
        intent.putExtra(EXTRA_PERMISSIONS, permissions.toArray(new String[0]));
        activity.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent().hasExtra(EXTRA_PERMISSIONS)) {
            this.permissions = this.getIntent().getStringArrayExtra(EXTRA_PERMISSIONS);
            if (Build.VERSION.SDK_INT >= 23 && this.permissions != null && this.permissions.length > 0) {
                this.getWindow().setStatusBarColor(0);
                this.requestPermissions(this.permissions, 6937);
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        cleanHandlerOnDestroy = true;
                    }
                }, 1000L);
            } else {
                this.finish();
            }
        } else {
            this.finish();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissionHandler == null) {
            this.finish();
            return;
        }
        if (grantResults.length == 0) {
            permissionHandler.onDenied((Context)this, Arrays.asList(this.permissions));
            this.finish();
        } else {
            boolean allPermissionsGranted = true;
            for (int grantResult : grantResults) {
                if (grantResult == 0) continue;
                allPermissionsGranted = false;
                break;
            }
            if (allPermissionsGranted) {
                permissionHandler.onJustGranted();
                this.finish();
            } else {
                this.handlePermissionsSetNotToAskAgain(permissions, permissionHandler);
            }
        }
    }

    @TargetApi(value=23)
    private void handlePermissionsSetNotToAskAgain(String[] permissions, final PermissionHandler permissionHandler) {
        final ArrayList<String> deniedPermissions = new ArrayList<String>();
        ArrayList<String> permissionsWhichCantBeAsked = new ArrayList<String>();
        for (String permission : permissions) {
            if (this.shouldShowRequestPermissionRationale(permission)) {
                Log.d((String)TAG, (String)(permission + " denied."));
                deniedPermissions.add(permission);
                continue;
            }
            if (this.checkSelfPermission(permission) == 0) continue;
            Log.d((String)TAG, (String)("Cant't ask " + permission + " again."));
            permissionsWhichCantBeAsked.add(permission);
            deniedPermissions.add(permission);
        }
        if (permissionsWhichCantBeAsked.size() == 0) {
            permissionHandler.onDenied((Context)this, deniedPermissions);
            this.finish();
        } else if (!permissionHandler.onSetNotToAskAgain((Context)this, permissionsWhichCantBeAsked)) {
            final Permissions activity = this;
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)dialogTitle).setMessage((CharSequence)forceDeniedDialogMessage).setPositiveButton((CharSequence)settingsText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)activity.getPackageName(), null));
                    if (recheckPermissionsAfterSettings) {
                        Permissions.this.startActivityForResult(intent, 6739);
                    } else {
                        Permissions.this.startActivity(intent);
                        Permissions.this.finish();
                    }
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    permissionHandler.onDenied((Context)activity, deniedPermissions);
                    Permissions.this.finish();
                }
            }).setCancelable(false).create().show();
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 6739 && permissionHandler != null) {
            Permissions.checkPermissionsAfterSettings(this, permissionHandler, this.permissions);
        } else {
            this.finish();
        }
    }

    @TargetApi(value=23)
    private static void checkPermissionsAfterSettings(Activity activity, PermissionHandler permissionHandler, String[] permissions) {
        boolean allPermissionProvided = true;
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String otherPermission : permissions) {
            if (activity.checkSelfPermission(otherPermission) == 0) continue;
            allPermissionProvided = false;
            deniedPermissions.add(otherPermission);
        }
        if (allPermissionProvided) {
            Log.d((String)TAG, (String)"Permission(s) just granted from settings.");
            permissionHandler.onJustGranted();
        } else {
            Log.d((String)TAG, (String)"Permission(s) not provided from settings, asking again.");
            Permissions.requestPermissions(activity, deniedPermissions, permissionHandler);
        }
        activity.finish();
    }

    protected void onDestroy() {
        if (cleanHandlerOnDestroy) {
            permissionHandler = null;
        }
        super.onDestroy();
    }
}

