/*
 * Decompiled with CFR 0.152.
 */
package com.nabinbhandari.android.permissions;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import java.util.List;

public abstract class PermissionHandler {
    private static final String TAG = "PermissionHandler";

    public abstract void onGranted();

    public void onJustGranted() {
        Log.d((String)TAG, (String)"Permission(s) just granted.");
        this.onGranted();
    }

    public void onDenied(Context context, List<String> deniedPermissions) {
        StringBuilder builder = new StringBuilder();
        builder.append("Denied:");
        for (String permission : deniedPermissions) {
            builder.append(" ");
            builder.append(permission);
        }
        Log.d((String)TAG, (String)builder.toString());
        Toast.makeText((Context)context, (CharSequence)"Permission Denied.", (int)0).show();
    }

    public boolean onSetNotToAskAgain(Context context, List<String> permissionsWhichCantBeAsked) {
        StringBuilder builder = new StringBuilder();
        builder.append("Set not to ask again:");
        for (String permission : permissionsWhichCantBeAsked) {
            builder.append(" ");
            builder.append(permission);
        }
        Log.d((String)TAG, (String)builder.toString());
        return false;
    }
}

