/*
 * Decompiled with CFR 0.152.
 */
package com.nabinbhandari.android.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.nabinbhandari.android.permissions.PermissionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Permissions {
    public static String dialogTitle = "Permission Required";
    public static String settingsText = "Settings";
    public static String forceDeniedDialogMessage = "Required permission(s) have been set not to ask again! Please provide them from settings.";
    public static int requestCodeForSettings = 6739;
    private static final int RC_PERMISSION = 6937;
    private static final String TAG = "Permissions";
    private static PermissionHandler permissionHandler;

    public static void runPermissionCheck(final Activity activity, String rationale, final PermissionHandler permissionHandler, String permission, String ... otherPermissions) {
        if (Build.VERSION.SDK_INT < 23) {
            permissionHandler.onGranted();
            Log.d((String)TAG, (String)"Android version < 23");
        } else {
            boolean allPermissionProvided = true;
            final ArrayList<String> deniedPermissions = new ArrayList<String>();
            if (activity.checkSelfPermission(permission) != 0) {
                allPermissionProvided = false;
                deniedPermissions.add(permission);
            }
            for (String otherPermission : otherPermissions) {
                if (activity.checkSelfPermission(otherPermission) == 0) continue;
                allPermissionProvided = false;
                deniedPermissions.add(otherPermission);
            }
            if (allPermissionProvided) {
                permissionHandler.onGranted();
                Log.d((String)TAG, (String)("Permission" + (otherPermissions.length == 0 ? "" : "s") + " already granted."));
            } else {
                boolean rationaleShouldBeShown = false;
                if (TextUtils.isEmpty((CharSequence)rationale)) {
                    rationaleShouldBeShown = false;
                } else {
                    for (String unGrantedPermission : deniedPermissions) {
                        if (!activity.shouldShowRequestPermissionRationale(unGrantedPermission)) continue;
                        rationaleShouldBeShown = true;
                        break;
                    }
                }
                if (rationaleShouldBeShown) {
                    new AlertDialog.Builder((Context)activity).setTitle((CharSequence)dialogTitle).setMessage((CharSequence)rationale).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            Permissions.requestPermissions(activity, deniedPermissions, permissionHandler);
                        }
                    }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            permissionHandler.onDenied((Context)activity, deniedPermissions);
                        }
                    }).setCancelable(false).create().show();
                } else {
                    Permissions.requestPermissions(activity, deniedPermissions, permissionHandler);
                }
            }
        }
    }

    @TargetApi(value=23)
    private static void requestPermissions(Activity activity, List<String> permissions, PermissionHandler permissionHandler) {
        activity.requestPermissions(permissions.toArray(new String[0]), 6937);
        Permissions.permissionHandler = permissionHandler;
    }

    public static void onRequestPermissionsResult(Activity activity, String[] permissions, int[] grantResults) {
        if (permissionHandler == null) {
            return;
        }
        if (grantResults.length == 0) {
            permissionHandler.onDenied((Context)activity, Arrays.asList(permissions));
        } else {
            boolean allPermissionsGranted = true;
            for (int grantResult : grantResults) {
                if (grantResult == 0) continue;
                allPermissionsGranted = false;
                break;
            }
            if (allPermissionsGranted) {
                permissionHandler.onJustGranted();
            } else {
                Permissions.handlePermissionsSetNotToAskAgain(activity, permissions, permissionHandler);
            }
        }
        permissionHandler = null;
    }

    private static void handlePermissionsSetNotToAskAgain(final Activity activity, String[] permissions, final PermissionHandler permissionHandler) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        final ArrayList<String> deniedPermissions = new ArrayList<String>();
        ArrayList<String> permissionsWhichCantBeAsked = new ArrayList<String>();
        for (String permission : permissions) {
            if (activity.shouldShowRequestPermissionRationale(permission)) {
                Log.d((String)TAG, (String)(permission + " denied."));
                deniedPermissions.add(permission);
                continue;
            }
            if (activity.checkSelfPermission(permission) == 0) continue;
            Log.d((String)TAG, (String)("Cant't ask " + permission + " again."));
            permissionsWhichCantBeAsked.add(permission);
            deniedPermissions.add(permission);
        }
        if (permissionsWhichCantBeAsked.size() == 0) {
            permissionHandler.onDenied((Context)activity, deniedPermissions);
        } else if (!permissionHandler.onSetNotToAskAgain(permissionsWhichCantBeAsked)) {
            new AlertDialog.Builder((Context)activity).setTitle((CharSequence)dialogTitle).setMessage((CharSequence)forceDeniedDialogMessage).setPositiveButton((CharSequence)settingsText, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)activity.getPackageName(), null));
                    activity.startActivityForResult(intent, requestCodeForSettings);
                    permissionHandler.onGoneToSettings(true, (Context)activity, deniedPermissions, requestCodeForSettings);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    permissionHandler.onGoneToSettings(false, (Context)activity, deniedPermissions, 0);
                }
            }).setCancelable(false).create().show();
        }
    }
}

