/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.spatial.split;

import com.google.common.collect.Lists;
import com.metamx.collections.spatial.Node;
import com.metamx.collections.spatial.RTreeUtils;
import com.metamx.collections.spatial.split.SplitStrategy;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class GutmanSplitStrategy
implements SplitStrategy {
    private final int minNumChildren;
    private final int maxNumChildren;

    protected GutmanSplitStrategy(int minNumChildren, int maxNumChildren) {
        this.minNumChildren = minNumChildren;
        this.maxNumChildren = maxNumChildren;
    }

    @Override
    public boolean needToSplit(Node node) {
        return node.getChildren().size() > this.maxNumChildren;
    }

    @Override
    public Node[] split(Node node) {
        ArrayList children = Lists.newArrayList(node.getChildren());
        Node[] seeds = this.pickSeeds(children);
        node.clear();
        node.addChild(seeds[0]);
        node.addToConciseSet(seeds[0]);
        Node group1 = new Node(Arrays.copyOf(seeds[1].getMinCoordinates(), seeds[1].getMinCoordinates().length), Arrays.copyOf(seeds[1].getMaxCoordinates(), seeds[1].getMaxCoordinates().length), Lists.newArrayList((Object[])new Node[]{seeds[1]}), node.isLeaf(), node.getParent(), new ConciseSet());
        group1.addToConciseSet(seeds[1]);
        if (node.getParent() != null) {
            node.getParent().addChild(group1);
        }
        Node[] groups = new Node[]{node, group1};
        RTreeUtils.enclose(groups);
        while (!children.isEmpty()) {
            double group1ExpandedArea;
            for (Node group : groups) {
                if (group.getChildren().size() + children.size() > this.minNumChildren) continue;
                for (Node child : group.getChildren()) {
                    group.addToConciseSet(child);
                    group.addChild(child);
                }
                RTreeUtils.enclose(groups);
                return groups;
            }
            Node nextToAssign = this.pickNext(children, groups);
            double group0ExpandedArea = RTreeUtils.getEnclosingArea(groups[0], nextToAssign);
            Node optimal = group0ExpandedArea < (group1ExpandedArea = RTreeUtils.getEnclosingArea(groups[1], nextToAssign)) ? groups[0] : (group0ExpandedArea == group1ExpandedArea ? (groups[0].getArea() < groups[1].getArea() ? groups[0] : groups[1]) : groups[1]);
            optimal.addToConciseSet(nextToAssign);
            optimal.addChild(nextToAssign);
            optimal.enclose();
        }
        return groups;
    }

    public abstract Node[] pickSeeds(List<Node> var1);

    public abstract Node pickNext(List<Node> var1, Node[] var2);
}

