/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.spatial.search;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.metamx.collections.spatial.ImmutableNode;
import com.metamx.collections.spatial.ImmutablePoint;
import com.metamx.collections.spatial.search.Bound;
import com.metamx.collections.spatial.search.SearchStrategy;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;

public class GutmanSearchStrategy
implements SearchStrategy {
    @Override
    public Iterable<ImmutableConciseSet> search(ImmutableNode node, Bound bound) {
        if (bound.getLimit() > 0) {
            return Iterables.transform(this.breadthFirstSearch(node, bound), (Function)new Function<ImmutableNode, ImmutableConciseSet>(){

                public ImmutableConciseSet apply(ImmutableNode immutableNode) {
                    return immutableNode.getImmutableConciseSet();
                }
            });
        }
        return Iterables.transform(this.depthFirstSearch(node, bound), (Function)new Function<ImmutablePoint, ImmutableConciseSet>(){

            public ImmutableConciseSet apply(ImmutablePoint immutablePoint) {
                return immutablePoint.getImmutableConciseSet();
            }
        });
    }

    public Iterable<ImmutablePoint> depthFirstSearch(ImmutableNode node, final Bound bound) {
        if (node.isLeaf()) {
            return bound.filter(Iterables.transform(node.getChildren(), (Function)new Function<ImmutableNode, ImmutablePoint>(){

                public ImmutablePoint apply(ImmutableNode tNode) {
                    return new ImmutablePoint(tNode);
                }
            }));
        }
        return Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter(node.getChildren(), (Predicate)new Predicate<ImmutableNode>(){

            public boolean apply(ImmutableNode child) {
                return bound.overlaps(child);
            }
        }), (Function)new Function<ImmutableNode, Iterable<ImmutablePoint>>(){

            public Iterable<ImmutablePoint> apply(ImmutableNode child) {
                return GutmanSearchStrategy.this.depthFirstSearch(child, bound);
            }
        }));
    }

    public Iterable<ImmutableNode> breadthFirstSearch(ImmutableNode node, final Bound bound) {
        if (node.isLeaf()) {
            return Iterables.filter(node.getChildren(), (Predicate)new Predicate<ImmutableNode>(){

                public boolean apply(ImmutableNode immutableNode) {
                    return bound.contains(immutableNode.getMinCoordinates());
                }
            });
        }
        return this.breadthFirstSearch(node.getChildren(), bound, 0);
    }

    public Iterable<ImmutableNode> breadthFirstSearch(Iterable<ImmutableNode> nodes, final Bound bound, int total) {
        Iterable points = Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.filter(nodes, (Predicate)new Predicate<ImmutableNode>(){

            public boolean apply(ImmutableNode immutableNode) {
                return immutableNode.isLeaf();
            }
        }), (Function)new Function<ImmutableNode, Iterable<ImmutableNode>>(){

            public Iterable<ImmutableNode> apply(ImmutableNode immutableNode) {
                return Iterables.filter(immutableNode.getChildren(), (Predicate)new Predicate<ImmutableNode>(){

                    public boolean apply(ImmutableNode immutableNode) {
                        return bound.contains(immutableNode.getMinCoordinates());
                    }
                });
            }
        }));
        Iterable overlappingNodes = Iterables.filter(nodes, (Predicate)new Predicate<ImmutableNode>(){

            public boolean apply(ImmutableNode immutableNode) {
                return !immutableNode.isLeaf() && bound.overlaps(immutableNode);
            }
        });
        int totalPoints = Iterables.size((Iterable)points);
        int totalOverlap = Iterables.size((Iterable)overlappingNodes);
        if (totalOverlap == 0 || totalPoints + totalOverlap + total >= bound.getLimit()) {
            return Iterables.concat((Iterable)points, (Iterable)overlappingNodes);
        }
        return Iterables.concat((Iterable)points, this.breadthFirstSearch(Iterables.concat((Iterable)Iterables.transform((Iterable)overlappingNodes, (Function)new Function<ImmutableNode, Iterable<ImmutableNode>>(){

            public Iterable<ImmutableNode> apply(ImmutableNode immutableNode) {
                return immutableNode.getChildren();
            }
        })), bound, totalPoints));
    }
}

