/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.collections.spatial;

import com.google.common.base.Preconditions;
import com.metamx.collections.spatial.ImmutableNode;
import com.metamx.collections.spatial.Node;
import com.metamx.collections.spatial.RTree;
import com.metamx.collections.spatial.search.Bound;
import com.metamx.collections.spatial.search.GutmanSearchStrategy;
import com.metamx.collections.spatial.search.SearchStrategy;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.nio.ByteBuffer;

public class ImmutableRTree {
    private static byte VERSION = 0;
    private final int numDims;
    private final ImmutableNode root;
    private final ByteBuffer data;
    private final SearchStrategy defaultSearchStrategy = new GutmanSearchStrategy();

    public static ImmutableRTree newImmutableFromMutable(RTree rTree) {
        if (rTree.getSize() == 0) {
            return new ImmutableRTree();
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[ImmutableRTree.calcNumBytes(rTree)]);
        buffer.put(VERSION);
        buffer.putInt(rTree.getNumDims());
        rTree.getRoot().storeInByteBuffer(buffer, buffer.position());
        buffer.position(0);
        return new ImmutableRTree(buffer.asReadOnlyBuffer());
    }

    private static int calcNumBytes(RTree tree) {
        int total = 5;
        return total += ImmutableRTree.calcNodeBytes(tree.getRoot());
    }

    private static int calcNodeBytes(Node node) {
        int total = 0;
        total += node.getSizeInBytes();
        for (Node child : node.getChildren()) {
            if (node.isLeaf()) {
                total += child.getSizeInBytes();
                continue;
            }
            total += ImmutableRTree.calcNodeBytes(child);
        }
        return total;
    }

    public ImmutableRTree() {
        this.numDims = 0;
        this.data = ByteBuffer.wrap(new byte[0]);
        this.root = null;
    }

    public ImmutableRTree(ByteBuffer data) {
        int initPosition = data.position();
        Preconditions.checkArgument((data.get(0) == VERSION ? 1 : 0) != 0, (Object)"Mismatching versions");
        this.numDims = data.getInt(1 + initPosition) & Short.MAX_VALUE;
        this.data = data;
        this.root = new ImmutableNode(this.numDims, initPosition, 5, data);
    }

    public int size() {
        return this.data.capacity();
    }

    public ImmutableNode getRoot() {
        return this.root;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public Iterable<ImmutableConciseSet> search(Bound bound) {
        Preconditions.checkArgument((bound.getNumDims() == this.numDims ? 1 : 0) != 0);
        return this.defaultSearchStrategy.search(this.root, bound);
    }

    public Iterable<ImmutableConciseSet> search(SearchStrategy strategy, Bound bound) {
        Preconditions.checkArgument((bound.getNumDims() == this.numDims ? 1 : 0) != 0);
        return strategy.search(this.root, bound);
    }

    public byte[] toBytes() {
        ByteBuffer buf = ByteBuffer.allocate(this.data.capacity());
        buf.put(this.data.asReadOnlyBuffer());
        return buf.array();
    }

    public int compareTo(ImmutableRTree other) {
        return this.data.compareTo(other.data);
    }
}

