/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.n1analytics.paillier.EncryptedNumber;
import com.n1analytics.paillier.PaillierContext;
import com.n1analytics.paillier.PaillierPrivateKey;
import com.n1analytics.paillier.PaillierPublicKey;
import java.math.BigInteger;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class SerialisationUtil {
    public static PaillierPublicKey unserialise_public(Map map) {
        BigInteger bigInteger = new BigInteger(1, Base64.decodeBase64((String)((String)map.get("n"))));
        return new PaillierPublicKey(bigInteger);
    }

    public static PaillierPrivateKey unserialise_private(Map map) {
        PaillierPublicKey paillierPublicKey = SerialisationUtil.unserialise_public((Map)map.get("pub"));
        BigInteger bigInteger = new BigInteger(1, Base64.decodeBase64((String)((String)map.get("lambda"))));
        BigInteger bigInteger2 = new BigInteger(1, Base64.decodeBase64((String)((String)map.get("mu"))));
        return new PaillierPrivateKey(paillierPublicKey, bigInteger);
    }

    public static ObjectNode serialise_encrypted(EncryptedNumber encryptedNumber) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("v", encryptedNumber.calculateCiphertext().toString());
        objectNode.put("e", encryptedNumber.getExponent());
        return objectNode;
    }

    public static EncryptedNumber unserialise_encrypted(Map map, PaillierPublicKey paillierPublicKey) {
        BigInteger bigInteger = new BigInteger(map.get("v").toString());
        int n = Integer.parseInt(map.get("e").toString());
        PaillierContext paillierContext = paillierPublicKey.createSignedContext();
        return new EncryptedNumber(paillierContext, bigInteger, n);
    }
}

