/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.n1analytics.paillier.PaillierPublicKey;
import java.math.BigInteger;
import org.apache.commons.codec.binary.Base64;

public class PublicKeyJsonSerialiser
implements PaillierPublicKey.Serializer {
    ObjectNode data;
    ObjectMapper mapper = new ObjectMapper();
    String comment;

    PublicKeyJsonSerialiser(String string) {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.comment = string;
    }

    public ObjectNode getNode() {
        return this.data;
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public void serialize(BigInteger bigInteger) {
        this.data = this.mapper.createObjectNode();
        this.data.put("alg", "PAI-GN1");
        this.data.put("kty", "DAJ");
        this.data.put("kid", this.comment);
        String string = new String(Base64.encodeBase64URLSafeString((byte[])bigInteger.toByteArray()));
        this.data.put("n", string);
        ArrayNode arrayNode = this.data.putArray("key_ops");
        arrayNode.add("encrypt");
    }
}

