/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.n1analytics.paillier.PaillierPrivateKey;
import com.n1analytics.paillier.PaillierPublicKey;
import com.n1analytics.paillier.cli.PublicKeyJsonSerialiser;
import com.n1analytics.paillier.util.BigIntegerUtil;
import java.math.BigInteger;
import org.apache.commons.codec.binary.Base64;

public class PrivateKeyJsonSerialiser
implements PaillierPrivateKey.Serializer {
    ObjectNode data;
    ObjectMapper mapper = new ObjectMapper();
    String comment;

    public PrivateKeyJsonSerialiser(String string) {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.comment = string;
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public void serialize(PaillierPublicKey paillierPublicKey, BigInteger bigInteger, BigInteger bigInteger2) {
        this.data = this.mapper.createObjectNode();
        this.data.put("kty", "DAJ");
        ArrayNode arrayNode = this.data.putArray("key_ops");
        arrayNode.add("decrypt");
        PublicKeyJsonSerialiser publicKeyJsonSerialiser = new PublicKeyJsonSerialiser(this.comment);
        paillierPublicKey.serialize(publicKeyJsonSerialiser);
        this.data.set("pub", (JsonNode)publicKeyJsonSerialiser.getNode());
        this.data.put("kid", this.comment);
        BigInteger bigInteger3 = bigInteger.subtract(BigInteger.ONE).multiply(bigInteger2.subtract(BigInteger.ONE));
        String string = new String(Base64.encodeBase64URLSafeString((byte[])bigInteger3.toByteArray()));
        this.data.put("lambda", string);
        BigInteger bigInteger4 = BigIntegerUtil.modInverse(bigInteger3, paillierPublicKey.getModulus());
        String string2 = new String(Base64.encodeBase64URLSafeString((byte[])bigInteger4.toByteArray()));
        this.data.put("mu", string2);
    }
}

