/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier;

import com.n1analytics.paillier.DecodeException;
import com.n1analytics.paillier.EncodeException;
import com.n1analytics.paillier.EncodedNumber;
import com.n1analytics.paillier.EncodingScheme;
import com.n1analytics.paillier.PaillierContext;
import com.n1analytics.paillier.util.BigIntegerUtil;
import com.n1analytics.paillier.util.HashChain;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class StandardEncodingScheme
implements EncodingScheme {
    private static final int DOUBLE_MANTISSA_BITS = 53;
    private final double log2Base;
    private final boolean signed;
    private final int precision;
    private final BigInteger maxEncoded;
    private final BigInteger minEncoded;
    private final BigInteger maxSignificand;
    private final BigInteger minSignificand;
    private final int base;
    private final PaillierContext context;
    private static final double LOG10 = Math.log(10.0);
    private static final double LOG2 = Math.log(2.0);

    public StandardEncodingScheme(PaillierContext paillierContext, boolean bl, int n, int n2) {
        BigInteger bigInteger;
        this.context = paillierContext;
        this.signed = bl;
        if (n2 < 2) {
            throw new IllegalArgumentException("Base must be at least equals to 2.");
        }
        this.base = n2;
        this.log2Base = Math.log(n2) / Math.log(2.0);
        BigInteger bigInteger2 = paillierContext.getPublicKey().getModulus();
        if (bigInteger2.bitLength() < n || n < 1) {
            throw new IllegalArgumentException("Precision must be greater than zero and less than or equal to the number of bits in the modulus");
        }
        if (bl && n < 2) {
            throw new IllegalArgumentException("Precision must be greater than one when signed is true");
        }
        this.precision = n;
        BigInteger bigInteger3 = bigInteger = bigInteger2.bitLength() == n ? bigInteger2 : BigInteger.ONE.shiftLeft(n);
        if (bl) {
            this.maxEncoded = bigInteger.add(BigInteger.ONE).shiftRight(1).subtract(BigInteger.ONE);
            this.minEncoded = bigInteger2.subtract(this.maxEncoded);
            this.maxSignificand = this.maxEncoded;
            this.minSignificand = this.maxEncoded.negate();
        } else {
            this.maxEncoded = bigInteger.subtract(BigInteger.ONE);
            this.minEncoded = BigInteger.ZERO;
            this.maxSignificand = this.maxEncoded;
            this.minSignificand = BigInteger.ZERO;
        }
    }

    @Override
    public EncodedNumber encode(BigInteger bigInteger) throws EncodeException {
        if (bigInteger == null) {
            throw new EncodeException("cannot encode 'null'");
        }
        if (bigInteger.compareTo(BigInteger.ZERO) < 0 && this.isUnsigned()) {
            throw new EncodeException("Input value cannot be encoded using this EncodingScheme.");
        }
        int n = 0;
        if (!bigInteger.equals(BigInteger.ZERO)) {
            while (bigInteger.mod(BigInteger.valueOf(this.base)).equals(BigInteger.ZERO)) {
                bigInteger = bigInteger.divide(BigInteger.valueOf(this.base));
                ++n;
            }
        }
        if (BigIntegerUtil.greater(bigInteger, this.maxSignificand) || BigIntegerUtil.less(bigInteger, this.minSignificand)) {
            throw new EncodeException("Input value cannot be encoded.");
        }
        if (bigInteger.signum() < 0) {
            bigInteger = bigInteger.add(this.context.getPublicKey().getModulus());
        }
        return new EncodedNumber(this.context, bigInteger, n);
    }

    @Override
    public EncodedNumber encode(double d) throws EncodeException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new EncodeException("Input value cannot be encoded.");
        }
        if (d < 0.0 && this.isUnsigned()) {
            throw new EncodeException("Input value cannot be encoded using this EncodingScheme.");
        }
        int n = d == 0.0 ? 0 : this.getDoublePrecExponent(d);
        return new EncodedNumber(this.context, this.innerEncode(new BigDecimal(d), n), n);
    }

    @Override
    public EncodedNumber encode(double d, int n) throws EncodeException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new EncodeException("Input value cannot be encoded.");
        }
        if (d < 0.0 && this.isUnsigned()) {
            throw new EncodeException("Input value is not valid for this Paillier context.");
        }
        int n2 = this.getExponent(this.getDoublePrecExponent(d), n);
        return new EncodedNumber(this.context, this.innerEncode(new BigDecimal(d), this.getExponent(this.getDoublePrecExponent(d), n)), n2);
    }

    @Override
    public EncodedNumber encode(double d, double d2) throws EncodeException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new EncodeException("Input value cannot be encoded.");
        }
        if (d < 0.0 && this.isUnsigned()) {
            throw new EncodeException("Input value is not valid for this Paillier context.");
        }
        if (d2 > 1.0 || d2 <= 0.0) {
            throw new EncodeException("Precision must be 10^-i where i > 0.");
        }
        int n = this.getPrecExponent(d2);
        return new EncodedNumber(this.context, this.innerEncode(new BigDecimal(d), n), n);
    }

    @Override
    public EncodedNumber encode(long l) throws EncodeException {
        return this.encode(BigInteger.valueOf(l));
    }

    @Override
    public EncodedNumber encode(BigDecimal bigDecimal) throws EncodeException {
        return this.encode(bigDecimal, 34);
    }

    @Override
    public EncodedNumber encode(BigDecimal bigDecimal, int n) throws EncodeException {
        if (bigDecimal == null) {
            throw new EncodeException("cannot encode 'null'");
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0 && this.isUnsigned()) {
            throw new EncodeException("Input value cannot be encoded using this EncodingScheme.");
        }
        if (this.base == 10) {
            int n2 = -bigDecimal.scale();
            BigInteger bigInteger = bigDecimal.scale() > 0 ? bigDecimal.scaleByPowerOfTen(bigDecimal.scale()).toBigInteger() : bigDecimal.unscaledValue();
            if (BigIntegerUtil.greater(bigInteger, this.maxSignificand) || BigIntegerUtil.less(bigInteger, this.minSignificand)) {
                throw new EncodeException("Input value cannot be encoded.");
            }
            if (bigInteger.signum() < 0) {
                bigInteger = this.context.getPublicKey().getModulus().add(bigInteger);
            }
            return new EncodedNumber(this.context, bigInteger, n2);
        }
        if (bigDecimal.scale() > 0) {
            BigDecimal bigDecimal2 = new BigDecimal(BigInteger.ONE, n);
            MathContext mathContext = new MathContext(n + 1, RoundingMode.HALF_EVEN);
            int n3 = (int)Math.floor(StandardEncodingScheme.logBigDecimal(bigDecimal.multiply(bigDecimal2, mathContext), this.base));
            BigDecimal bigDecimal3 = n3 < 0 ? bigDecimal.multiply(BigDecimal.valueOf(this.base).pow(-n3, mathContext), mathContext) : bigDecimal.divide(BigDecimal.valueOf(this.base).pow(n3, mathContext), mathContext);
            BigInteger bigInteger = bigDecimal3.setScale(0, RoundingMode.HALF_EVEN).unscaledValue();
            if (BigIntegerUtil.greater(bigInteger, this.maxSignificand) || BigIntegerUtil.less(bigInteger, this.minSignificand)) {
                throw new EncodeException("Input value cannot be encoded.");
            }
            if (bigInteger.signum() < 0) {
                bigInteger = this.context.getPublicKey().getModulus().add(bigInteger);
            }
            return new EncodedNumber(this.context, bigInteger, n3);
        }
        return this.encode(bigDecimal.toBigInteger());
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    public boolean isUnsigned() {
        return !this.signed;
    }

    private int getDoublePrecExponent(double d) {
        int n = Math.getExponent(d) + 1;
        int n2 = n - 53;
        return (int)Math.floor((double)n2 / this.log2Base);
    }

    private BigInteger innerEncode(BigDecimal bigDecimal, int n) {
        BigDecimal bigDecimal2 = new BigDecimal(this.base).pow(-n, MathContext.DECIMAL128);
        BigInteger bigInteger = bigDecimal.multiply(bigDecimal2).setScale(0, 4).toBigInteger();
        if (BigIntegerUtil.greater(bigInteger, this.maxSignificand) || bigDecimal.signum() < 0 && BigIntegerUtil.less(bigInteger, this.minSignificand)) {
            throw new EncodeException("Input value cannot be encoded.");
        }
        if (bigInteger.signum() < 0) {
            bigInteger = bigInteger.add(this.context.getPublicKey().getModulus());
        }
        return bigInteger;
    }

    private int getExponent(int n, int n2) {
        return Math.min(n, n2);
    }

    private int getPrecExponent(double d) {
        return (int)Math.floor(Math.log(d) / Math.log(this.base));
    }

    @Override
    public int signum(EncodedNumber encodedNumber) {
        if (encodedNumber.value.equals(BigInteger.ZERO)) {
            return 0;
        }
        if (this.isUnsigned()) {
            return 1;
        }
        BigInteger bigInteger = this.context.getPublicKey().modulus.shiftRight(1);
        return encodedNumber.value.compareTo(bigInteger) > 0 ? -1 : 1;
    }

    @Override
    public int getBase() {
        return this.base;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public BigInteger getMaxEncoded() {
        return this.maxEncoded;
    }

    @Override
    public BigInteger getMinEncoded() {
        return this.minEncoded;
    }

    @Override
    public BigInteger getMaxSignificand() {
        return this.maxSignificand;
    }

    @Override
    public BigInteger getMinSignificand() {
        return this.minSignificand;
    }

    @Override
    public boolean isValid(EncodedNumber encodedNumber) {
        if (!this.context.equals(encodedNumber.getContext())) {
            return false;
        }
        if (encodedNumber.getValue().compareTo(this.maxEncoded) <= 0) {
            return true;
        }
        return this.signed && encodedNumber.getValue().compareTo(this.minEncoded) >= 0;
    }

    @Override
    public BigInteger decodeBigInteger(EncodedNumber encodedNumber) throws DecodeException {
        BigInteger bigInteger = this.getSignificand(encodedNumber);
        return bigInteger.multiply(BigInteger.valueOf(this.base).pow(encodedNumber.getExponent()));
    }

    @Override
    public double decodeDouble(EncodedNumber encodedNumber) throws DecodeException {
        BigInteger bigInteger = this.getSignificand(encodedNumber);
        BigDecimal bigDecimal = BigDecimal.valueOf(this.base).pow(Math.abs(encodedNumber.getExponent()));
        BigDecimal bigDecimal2 = encodedNumber.getExponent() < 0 ? new BigDecimal(bigInteger).divide(bigDecimal, MathContext.DECIMAL128) : new BigDecimal(bigInteger).multiply(bigDecimal, MathContext.DECIMAL128);
        double d = bigDecimal2.doubleValue();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new DecodeException("Decoded value cannot be represented as double.");
        }
        return d;
    }

    @Override
    public long decodeLong(EncodedNumber encodedNumber) throws DecodeException {
        BigInteger bigInteger = this.decodeBigInteger(encodedNumber);
        if (BigIntegerUtil.less(bigInteger, BigIntegerUtil.LONG_MIN_VALUE) || BigIntegerUtil.greater(bigInteger, BigIntegerUtil.LONG_MAX_VALUE)) {
            throw new DecodeException("Decoded value cannot be represented as long.");
        }
        return bigInteger.longValue();
    }

    @Override
    public BigDecimal decodeBigDecimal(EncodedNumber encodedNumber) throws DecodeException {
        return this.decodeBigDecimal(encodedNumber, 34);
    }

    @Override
    public BigDecimal decodeBigDecimal(EncodedNumber encodedNumber, int n) throws DecodeException {
        BigInteger bigInteger = this.getSignificand(encodedNumber);
        if (this.base == 10) {
            return new BigDecimal(bigInteger, -encodedNumber.getExponent());
        }
        MathContext mathContext = new MathContext(n + 1, RoundingMode.HALF_EVEN);
        BigDecimal bigDecimal = BigDecimal.valueOf(this.base).pow(encodedNumber.getExponent(), mathContext);
        return bigDecimal.multiply(new BigDecimal(bigInteger), mathContext);
    }

    private BigInteger getSignificand(EncodedNumber encodedNumber) {
        this.context.checkSameContext(encodedNumber);
        BigInteger bigInteger = encodedNumber.getValue();
        if (bigInteger.compareTo(this.context.getPublicKey().getModulus()) > 0) {
            throw new DecodeException("The significand of the encoded number is corrupted");
        }
        if (bigInteger.compareTo(this.maxEncoded) <= 0) {
            return bigInteger;
        }
        if (this.signed && bigInteger.compareTo(this.minEncoded) >= 0) {
            BigInteger bigInteger2 = this.context.getPublicKey().getModulus();
            return bigInteger.subtract(bigInteger2);
        }
        throw new DecodeException("Detected overflow");
    }

    @Override
    public BigInteger getRescalingFactor(int n) {
        return BigInteger.valueOf(this.base).pow(n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != StandardEncodingScheme.class) {
            return false;
        }
        StandardEncodingScheme standardEncodingScheme = (StandardEncodingScheme)object;
        return this.signed == standardEncodingScheme.signed && this.precision == standardEncodingScheme.precision && this.base == standardEncodingScheme.base;
    }

    public boolean equals(StandardEncodingScheme standardEncodingScheme) {
        return standardEncodingScheme == this || standardEncodingScheme != null && this.base == standardEncodingScheme.base && this.signed == standardEncodingScheme.signed && this.precision == standardEncodingScheme.precision;
    }

    public int hashCode() {
        return new HashChain().chain(this.base).chain(this.signed).chain(this.precision).hashCode();
    }

    private static double log2(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        long l = 0x10000000000000L;
        long l2 = 0L;
        int n2 = 0;
        for (int i = 1; i < 54 && (n2 = n - i) >= 0; ++i) {
            if (bigInteger.testBit(n2)) {
                l2 |= l;
            }
            l >>>= 1;
        }
        if (n2 > 0 && bigInteger.testBit(n2 - 1)) {
            ++l2;
        }
        double d = (double)l2 / 4.503599627370496E15;
        return (double)(n - 1) + Math.log(d) * 1.4426950408889634;
    }

    private static double logBigDecimal(BigDecimal bigDecimal, int n) {
        return (StandardEncodingScheme.log2(bigDecimal.unscaledValue()) * LOG2 - (double)bigDecimal.scale() * LOG10) / Math.log(n);
    }
}

