/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier;

import com.n1analytics.paillier.MockPaillierContext;
import com.n1analytics.paillier.PaillierContext;
import com.n1analytics.paillier.util.BigIntegerUtil;
import java.math.BigInteger;

public final class PaillierPublicKey {
    protected final BigInteger modulus;
    protected final BigInteger modulusSquared;
    protected final BigInteger generator;

    public PaillierPublicKey(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new NullPointerException("modulus must not be null");
        }
        this.modulus = bigInteger;
        this.modulusSquared = bigInteger.multiply(bigInteger);
        this.generator = bigInteger.add(BigInteger.ONE);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getModulusSquared() {
        return this.modulusSquared;
    }

    public BigInteger getGenerator() {
        return this.generator;
    }

    public void serialize(Serializer serializer) {
        serializer.serialize(this.modulus);
    }

    public PaillierContext createUnsignedContext() {
        return new PaillierContext(this, false, this.modulus.bitLength());
    }

    public PaillierContext createUnsignedContext(int n) throws IllegalArgumentException {
        return new PaillierContext(this, false, n);
    }

    public PaillierContext createSignedContext() {
        return new PaillierContext(this, true, this.modulus.bitLength());
    }

    public PaillierContext createSignedContext(int n) {
        return new PaillierContext(this, true, n);
    }

    public MockPaillierContext createMockUnsignedContext() {
        return new MockPaillierContext(this, false, this.modulus.bitLength());
    }

    public MockPaillierContext createMockUnsignedContext(int n) throws IllegalArgumentException {
        return new MockPaillierContext(this, false, n);
    }

    public MockPaillierContext createMockSignedContext() {
        return new MockPaillierContext(this, true, this.modulus.bitLength());
    }

    public MockPaillierContext createMockSignedContext(int n) {
        return new MockPaillierContext(this, true, n);
    }

    public BigInteger raw_encrypt(BigInteger bigInteger) {
        return this.raw_obfuscate(this.raw_encrypt_without_obfuscation(bigInteger));
    }

    public BigInteger raw_encrypt_without_obfuscation(BigInteger bigInteger) {
        return this.modulus.multiply(bigInteger).add(BigInteger.ONE).mod(this.modulusSquared);
    }

    public BigInteger raw_obfuscate(BigInteger bigInteger) {
        return BigIntegerUtil.modPow(BigIntegerUtil.randomPositiveNumber(this.modulus), this.modulus, this.modulusSquared).multiply(bigInteger).mod(this.modulusSquared);
    }

    public BigInteger raw_add(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.multiply(bigInteger2).mod(this.modulusSquared);
    }

    public BigInteger raw_multiply(BigInteger bigInteger, BigInteger bigInteger2) {
        return BigIntegerUtil.modPow(bigInteger, bigInteger2, this.modulusSquared);
    }

    public int hashCode() {
        return this.modulus.hashCode();
    }

    public boolean equals(Object object) {
        return object == this || object != null && object.getClass() == PaillierPublicKey.class && this.modulus.equals(((PaillierPublicKey)object).modulus);
    }

    public boolean equals(PaillierPublicKey paillierPublicKey) {
        return paillierPublicKey == this || paillierPublicKey != null && this.modulus.equals(paillierPublicKey.modulus);
    }

    public static interface Serializer {
        public void serialize(BigInteger var1);
    }
}

