/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier;

import com.n1analytics.paillier.EncodedNumber;
import com.n1analytics.paillier.EncryptedNumber;
import com.n1analytics.paillier.MockPaillierContext;
import com.n1analytics.paillier.PaillierKeyMismatchException;
import com.n1analytics.paillier.PaillierPublicKey;
import com.n1analytics.paillier.util.BigIntegerUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

public final class PaillierPrivateKey {
    protected final PaillierPublicKey publicKey;
    protected final BigInteger p;
    protected final BigInteger q;
    protected final BigInteger pSquared;
    protected final BigInteger qSquared;
    protected final BigInteger pInverse;
    protected final BigInteger hp;
    protected final BigInteger hq;

    public PaillierPrivateKey(PaillierPublicKey paillierPublicKey, BigInteger bigInteger) {
        if (paillierPublicKey == null) {
            throw new IllegalArgumentException("publicKey must not be null");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("totient must not be null");
        }
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException("totient must be non-negative");
        }
        if (bigInteger.compareTo(paillierPublicKey.getModulus()) >= 0) {
            throw new IllegalArgumentException("totient must be less than public key modulus");
        }
        this.publicKey = paillierPublicKey;
        BigInteger bigInteger2 = paillierPublicKey.modulus.subtract(bigInteger).add(BigInteger.ONE);
        BigInteger bigInteger3 = BigIntegerUtil.sqrt(bigInteger2.multiply(bigInteger2).subtract(paillierPublicKey.modulus.multiply(BigInteger.valueOf(4L))));
        this.q = bigInteger2.subtract(bigInteger3).divide(BigInteger.valueOf(2L));
        this.p = bigInteger2.subtract(this.q);
        this.qSquared = this.q.multiply(this.q);
        this.pSquared = this.p.multiply(this.p);
        this.pInverse = this.p.modInverse(this.q);
        this.hp = this.hFunction(this.p, this.pSquared);
        this.hq = this.hFunction(this.q, this.qSquared);
    }

    protected PaillierPrivateKey(PaillierPublicKey paillierPublicKey, BigInteger bigInteger, BigInteger bigInteger2) {
        if (paillierPublicKey == null) {
            throw new IllegalArgumentException("publicKey must not be null");
        }
        if (!paillierPublicKey.modulus.equals(bigInteger.multiply(bigInteger2))) {
            throw new IllegalArgumentException("publicKey does not match the given prime numbers.");
        }
        this.publicKey = paillierPublicKey;
        this.p = bigInteger;
        this.pSquared = bigInteger.multiply(bigInteger);
        this.q = bigInteger2;
        this.qSquared = bigInteger2.multiply(bigInteger2);
        this.pInverse = bigInteger.modInverse(bigInteger2);
        this.hp = this.hFunction(bigInteger, this.pSquared);
        this.hq = this.hFunction(bigInteger2, this.qSquared);
    }

    public static PaillierPrivateKey create(int n) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (n < 8 || n % 8 != 0) {
            throw new IllegalArgumentException("modulusLength must be a multiple of 8");
        }
        int n2 = n / 2;
        SecureRandom secureRandom = new SecureRandom();
        do {
            bigInteger2 = BigInteger.probablePrime(n2, secureRandom);
            while (bigInteger2.equals(bigInteger = BigInteger.probablePrime(n2, secureRandom))) {
            }
        } while ((bigInteger3 = bigInteger2.multiply(bigInteger)).bitLength() != n);
        PaillierPublicKey paillierPublicKey = new PaillierPublicKey(bigInteger3);
        return new PaillierPrivateKey(paillierPublicKey, bigInteger2, bigInteger);
    }

    public PaillierPublicKey getPublicKey() {
        return this.publicKey;
    }

    public EncodedNumber decrypt(EncryptedNumber encryptedNumber) throws PaillierKeyMismatchException {
        if (!this.publicKey.equals(encryptedNumber.getContext().getPublicKey())) {
            throw new PaillierKeyMismatchException();
        }
        if (encryptedNumber.getContext() instanceof MockPaillierContext) {
            return new EncodedNumber(encryptedNumber.getContext(), encryptedNumber.ciphertext, encryptedNumber.getExponent());
        }
        return new EncodedNumber(encryptedNumber.getContext(), this.raw_decrypt(encryptedNumber.ciphertext), encryptedNumber.getExponent());
    }

    public BigInteger raw_decrypt(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.lFunction(BigIntegerUtil.modPowSecure(bigInteger, this.p.subtract(BigInteger.ONE), this.pSquared), this.p).multiply(this.hp).mod(this.p);
        BigInteger bigInteger3 = this.lFunction(BigIntegerUtil.modPowSecure(bigInteger, this.q.subtract(BigInteger.ONE), this.qSquared), this.q).multiply(this.hq).mod(this.q);
        return this.crt(bigInteger2, bigInteger3);
    }

    private BigInteger lFunction(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.subtract(BigInteger.ONE).divide(bigInteger2);
    }

    private BigInteger hFunction(BigInteger bigInteger, BigInteger bigInteger2) {
        return this.lFunction(BigIntegerUtil.modPow(this.publicKey.generator, bigInteger.subtract(BigInteger.ONE), bigInteger2), bigInteger).modInverse(bigInteger);
    }

    private BigInteger crt(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger).multiply(this.pInverse).mod(this.q);
        return bigInteger.add(bigInteger3.multiply(this.p));
    }

    public void serialize(Serializer serializer) {
        serializer.serialize(this.publicKey, this.p, this.q);
    }

    public int hashCode() {
        return this.publicKey.hashCode();
    }

    public boolean equals(Object object) {
        return object == this || object != null && object.getClass() == PaillierPrivateKey.class && this.publicKey.equals(((PaillierPrivateKey)object).publicKey);
    }

    public boolean equals(PaillierPrivateKey paillierPrivateKey) {
        return paillierPrivateKey == this || paillierPrivateKey != null && this.publicKey.equals(paillierPrivateKey.publicKey);
    }

    public static interface Serializer {
        public void serialize(PaillierPublicKey var1, BigInteger var2, BigInteger var3);
    }
}

