/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier;

import com.n1analytics.paillier.EncodedNumber;
import com.n1analytics.paillier.EncryptedNumber;
import com.n1analytics.paillier.PaillierContext;
import com.n1analytics.paillier.PaillierContextMismatchException;
import com.n1analytics.paillier.PaillierPublicKey;
import java.math.BigInteger;
import java.util.logging.Logger;

public class MockPaillierContext
extends PaillierContext {
    private static Logger logger = Logger.getLogger("com.n1analytics.paillier");

    public MockPaillierContext(PaillierPublicKey paillierPublicKey, boolean bl, int n) {
        super(paillierPublicKey, bl, n);
        logger.warning("You are using the MockPaillierContext. Are you sure? This is NOT secure/private!");
    }

    public MockPaillierContext(PaillierPublicKey paillierPublicKey, boolean bl, int n, int n2) {
        super(paillierPublicKey, bl, n, n2);
        logger.warning("You are using the MockPaillierContext. Are you sure? This is NOT secure/private!");
    }

    @Override
    public EncryptedNumber obfuscate(EncryptedNumber encryptedNumber) {
        return encryptedNumber;
    }

    @Override
    public EncryptedNumber encrypt(EncodedNumber encodedNumber) {
        this.checkSameContext(encodedNumber);
        BigInteger bigInteger = this.getPublicKey().getModulus();
        BigInteger bigInteger2 = encodedNumber.getValue();
        return new EncryptedNumber(this, bigInteger2.mod(bigInteger), encodedNumber.getExponent());
    }

    @Override
    public EncryptedNumber add(EncryptedNumber encryptedNumber, EncryptedNumber encryptedNumber2) throws PaillierContextMismatchException {
        BigInteger bigInteger;
        this.checkSameContext(encryptedNumber);
        this.checkSameContext(encryptedNumber2);
        BigInteger bigInteger2 = this.getPublicKey().getModulus();
        BigInteger bigInteger3 = encryptedNumber.ciphertext;
        BigInteger bigInteger4 = encryptedNumber2.ciphertext;
        int n = encryptedNumber.getExponent();
        int n2 = encryptedNumber2.getExponent();
        if (n > n2) {
            bigInteger3 = bigInteger3.multiply(this.getRescalingFactor(n - n2)).mod(bigInteger2);
            n = n2;
        } else if (n < n2) {
            bigInteger4 = bigInteger4.multiply(this.getRescalingFactor(n2 - n)).mod(bigInteger2);
            n2 = n;
        }
        BigInteger bigInteger5 = bigInteger3.add(bigInteger4);
        BigInteger bigInteger6 = this.isSigned() && bigInteger3.compareTo(this.getMinEncoded()) >= 0 ? bigInteger3.subtract(this.getPublicKey().modulus) : bigInteger3;
        BigInteger bigInteger7 = bigInteger = this.isSigned() && bigInteger4.compareTo(this.getMinEncoded()) >= 0 ? bigInteger4.subtract(this.getPublicKey().modulus) : bigInteger4;
        if (bigInteger6.add(bigInteger).compareTo(bigInteger2) != -1) {
            logger.warning("Overflow occured in add()");
        }
        return new EncryptedNumber(this, bigInteger5.mod(bigInteger2), n);
    }

    @Override
    public EncryptedNumber additiveInverse(EncryptedNumber encryptedNumber) throws PaillierContextMismatchException {
        this.checkSameContext(encryptedNumber);
        return new EncryptedNumber(encryptedNumber.getContext(), this.getPublicKey().modulus.subtract(encryptedNumber.ciphertext), encryptedNumber.getExponent());
    }

    @Override
    public EncodedNumber additiveInverse(EncodedNumber encodedNumber) throws PaillierContextMismatchException {
        this.checkSameContext(encodedNumber);
        if (encodedNumber.getValue().signum() == 0) {
            return encodedNumber;
        }
        BigInteger bigInteger = this.getPublicKey().getModulus();
        BigInteger bigInteger2 = encodedNumber.getValue();
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        return new EncodedNumber(this, bigInteger3, encodedNumber.getExponent());
    }

    @Override
    public EncryptedNumber multiply(EncryptedNumber encryptedNumber, EncodedNumber encodedNumber) throws PaillierContextMismatchException {
        BigInteger bigInteger;
        this.checkSameContext(encryptedNumber);
        this.checkSameContext(encodedNumber);
        BigInteger bigInteger2 = encryptedNumber.ciphertext;
        BigInteger bigInteger3 = encodedNumber.getValue();
        BigInteger bigInteger4 = bigInteger2.multiply(bigInteger3);
        BigInteger bigInteger5 = this.isSigned() && bigInteger2.compareTo(this.getMinEncoded()) >= 0 ? bigInteger2.subtract(this.getPublicKey().modulus) : bigInteger2;
        BigInteger bigInteger6 = bigInteger = this.isSigned() && bigInteger3.compareTo(this.getMinEncoded()) >= 0 ? bigInteger3.subtract(this.getPublicKey().modulus) : bigInteger3;
        if (bigInteger5.multiply(bigInteger).compareTo(this.getPublicKey().getModulus()) != -1) {
            logger.warning("Overflow occured in multiply()");
        }
        int n = encryptedNumber.getExponent() + encodedNumber.getExponent();
        return new EncryptedNumber(this, bigInteger4.mod(this.getPublicKey().getModulus()), n);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != MockPaillierContext.class) {
            return false;
        }
        MockPaillierContext mockPaillierContext = (MockPaillierContext)object;
        return this.getPublicKey().equals(mockPaillierContext.getPublicKey()) && this.isSigned() == mockPaillierContext.isSigned() && this.getPrecision() == mockPaillierContext.getPrecision();
    }

    public boolean equals(MockPaillierContext mockPaillierContext) {
        return mockPaillierContext == this || mockPaillierContext != null && this.getPublicKey().equals(mockPaillierContext.getPublicKey()) && this.isSigned() == mockPaillierContext.isSigned() && this.getPrecision() == mockPaillierContext.getPrecision();
    }
}

