/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier;

import com.n1analytics.paillier.EncodedNumber;
import com.n1analytics.paillier.PaillierContext;
import com.n1analytics.paillier.PaillierContextMismatchException;
import com.n1analytics.paillier.PaillierPrivateKey;
import com.n1analytics.paillier.util.HashChain;
import java.math.BigInteger;

public final class EncryptedNumber {
    protected final PaillierContext context;
    protected final transient BigInteger ciphertext;
    protected final int exponent;
    protected final boolean isSafe;

    public EncryptedNumber(PaillierContext paillierContext, BigInteger bigInteger, int n, boolean bl) {
        if (paillierContext == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("unsafeCiphertext must not be null");
        }
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException("unsafeCiphertext must be non-negative");
        }
        if (bigInteger.compareTo(paillierContext.getPublicKey().getModulusSquared()) >= 0) {
            throw new IllegalArgumentException("unsafeCiphertext must be less than modulus squared");
        }
        this.context = paillierContext;
        this.ciphertext = bigInteger;
        this.exponent = n;
        this.isSafe = bl;
    }

    public EncryptedNumber(PaillierContext paillierContext, BigInteger bigInteger, int n) {
        this(paillierContext, bigInteger, n, false);
    }

    public PaillierContext getContext() {
        return this.context;
    }

    public EncryptedNumber getSafeEncryptedNumber() {
        return new EncryptedNumber(this.context, this.calculateCiphertext(), this.exponent, true);
    }

    public BigInteger calculateCiphertext() {
        return this.isSafe ? this.ciphertext : this.obfuscate().ciphertext;
    }

    public int getExponent() {
        return this.exponent;
    }

    public EncryptedNumber checkSameContext(EncryptedNumber encryptedNumber) throws PaillierContextMismatchException {
        return this.context.checkSameContext(encryptedNumber);
    }

    public EncodedNumber checkSameContext(EncodedNumber encodedNumber) throws PaillierContextMismatchException {
        return this.context.checkSameContext(encodedNumber);
    }

    public EncodedNumber decrypt(PaillierPrivateKey paillierPrivateKey) {
        return paillierPrivateKey.decrypt(this);
    }

    public EncryptedNumber obfuscate() {
        return this.context.obfuscate(this);
    }

    public EncryptedNumber decreaseExponentTo(int n) {
        return this.context.decreaseExponentTo(this, n);
    }

    public EncryptedNumber add(EncryptedNumber encryptedNumber) {
        return this.context.add(this, encryptedNumber);
    }

    public EncryptedNumber add(EncodedNumber encodedNumber) {
        return this.context.add(this, encodedNumber);
    }

    public EncryptedNumber add(BigInteger bigInteger) {
        return this.add(this.context.encode(bigInteger));
    }

    public EncryptedNumber add(double d) {
        return this.add(this.context.encode(d));
    }

    public EncryptedNumber add(long l) {
        return this.add(this.context.encode(l));
    }

    public EncryptedNumber additiveInverse() {
        return this.context.additiveInverse(this);
    }

    public EncryptedNumber subtract(EncryptedNumber encryptedNumber) {
        return this.context.subtract(this, encryptedNumber);
    }

    public EncryptedNumber subtract(EncodedNumber encodedNumber) {
        return this.context.subtract(this, encodedNumber);
    }

    public EncryptedNumber subtract(BigInteger bigInteger) {
        return this.subtract(this.context.encode(bigInteger));
    }

    public EncryptedNumber subtract(double d) {
        return this.subtract(this.context.encode(d));
    }

    public EncryptedNumber subtract(long l) {
        return this.subtract(this.context.encode(l));
    }

    public EncryptedNumber multiply(EncodedNumber encodedNumber) {
        return this.context.multiply(this, encodedNumber);
    }

    public EncryptedNumber multiply(BigInteger bigInteger) {
        return this.multiply(this.context.encode(bigInteger));
    }

    public EncryptedNumber multiply(double d) {
        return this.multiply(this.context.encode(d));
    }

    public EncryptedNumber multiply(long l) {
        return this.multiply(this.context.encode(l));
    }

    public EncryptedNumber divide(double d) {
        return this.multiply(this.context.encode(1.0 / d));
    }

    public EncryptedNumber divide(long l) {
        return this.multiply(this.context.encode(1.0 / (double)l));
    }

    public void serialize(Serializer serializer) {
        serializer.serialize(this.context, this.calculateCiphertext(), this.exponent);
    }

    public int hashCode() {
        return new HashChain().chain(this.context).chain(this.ciphertext).hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != EncryptedNumber.class) {
            return false;
        }
        EncryptedNumber encryptedNumber = (EncryptedNumber)object;
        return this.context.equals(encryptedNumber.context) && this.ciphertext.equals(encryptedNumber.ciphertext);
    }

    public boolean equals(EncryptedNumber encryptedNumber) {
        return encryptedNumber == this || encryptedNumber != null && this.context.equals(encryptedNumber.context) && this.ciphertext.equals(encryptedNumber.ciphertext);
    }

    public static interface Serializer {
        public void serialize(PaillierContext var1, BigInteger var2, int var3);
    }
}

