/*
 * Decompiled with CFR 0.152.
 */
package com.n1analytics.paillier;

import com.n1analytics.paillier.DecodeException;
import com.n1analytics.paillier.EncodeException;
import com.n1analytics.paillier.EncodedNumber;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface EncodingScheme {
    public static final int BIG_DECIMAL_ENCODING_PRECISION = 34;

    public int getBase();

    public boolean isSigned();

    public int getPrecision();

    public BigInteger getMaxEncoded();

    public BigInteger getMinEncoded();

    public BigInteger getMaxSignificand();

    public BigInteger getMinSignificand();

    public boolean isValid(EncodedNumber var1);

    public EncodedNumber encode(BigInteger var1) throws EncodeException;

    public EncodedNumber encode(double var1) throws EncodeException;

    public EncodedNumber encode(double var1, int var3) throws EncodeException;

    public EncodedNumber encode(double var1, double var3) throws EncodeException;

    public EncodedNumber encode(long var1) throws EncodeException;

    public EncodedNumber encode(BigDecimal var1, int var2) throws EncodeException;

    public EncodedNumber encode(BigDecimal var1) throws EncodeException;

    public int signum(EncodedNumber var1);

    public BigInteger decodeBigInteger(EncodedNumber var1) throws DecodeException;

    public double decodeDouble(EncodedNumber var1) throws DecodeException;

    public long decodeLong(EncodedNumber var1) throws DecodeException;

    public BigDecimal decodeBigDecimal(EncodedNumber var1, int var2) throws DecodeException;

    public BigDecimal decodeBigDecimal(EncodedNumber var1) throws DecodeException;

    public BigInteger getRescalingFactor(int var1);
}

