/*
 * Decompiled with CFR 0.152.
 */
package com.myvideoyun.giftrenderer;

import android.content.Context;

public class MvyRenderer {
    public static final int MSG_STAT_EFFECTS_PLAY = 131072;
    public static final int MSG_STAT_EFFECTS_END = 262144;
    public static final int MSG_STAT_EFFECTS_START = 524288;
    private long render;
    private String effectPath;
    private long faceData;
    private boolean enalbeVFilp;
    private boolean updateEffectPath;
    private boolean updateFaceData;
    private boolean updateVFlip;

    public void initGLResource() {
        this.render = this.Create();
    }

    public void releaseGLResource() {
        this.Destroy(this.render);
    }

    public void setCallback(OnEffectCallback callback) {
        this.Callback(this.render, callback);
    }

    public void processWithTexture(int texture, int width, int height) {
        if (this.updateEffectPath) {
            this.SetStickerPath(this.render, this.effectPath);
            this.updateEffectPath = false;
        }
        if (this.updateFaceData) {
            this.SetFaceData(this.render, this.faceData);
            this.updateFaceData = false;
        } else {
            this.SetFaceData(this.render, 0L);
        }
        if (this.updateVFlip) {
            this.SetEnableVFlip(this.render, this.enalbeVFilp);
        }
        this.Draw(this.render, texture, width, height);
    }

    public void pauseProcess() {
        this.SetPause(this.render);
    }

    public void resumeProcess() {
        this.SetResume(this.render);
    }

    public void setEffectPath(String effectPath) {
        this.effectPath = effectPath;
        this.updateEffectPath = true;
    }

    public void SetMVPMatrix(float[] mvp) {
        this.SetMVPMatrix(this.render, mvp);
    }

    public void setFaceData(long faceData) {
        this.faceData = faceData;
        this.updateFaceData = true;
    }

    public void setEnalbeVFilp(boolean enalbeVFilp) {
        this.enalbeVFilp = enalbeVFilp;
        this.updateVFlip = true;
    }

    native long Create();

    native void Destroy(long var1);

    native void Callback(long var1, OnEffectCallback var3);

    native void SetFaceData(long var1, long var3);

    native void SetStickerPath(long var1, String var3);

    native void SetEnableVFlip(long var1, boolean var3);

    native void SetPause(long var1);

    native void SetResume(long var1);

    native void SetMVPMatrix(long var1, float[] var3);

    native void Draw(long var1, int var3, int var4, int var5);

    public static native int InitLicense(Context var0, String var1, int var2);

    public static native int InitLicenseEx(Context var0, String var1, int var2, String var3, int var4);

    static {
        System.loadLibrary("lightgift");
        System.loadLibrary("MvyRendererJni");
    }

    public static interface OnEffectCallback {
        public void MVYRenderMsg(int var1, int var2);
    }
}

