/*
 * Decompiled with CFR 0.152.
 */
package com.mytechia.robobo.framework.remotecontrol.ws;

import android.content.res.AssetManager;
import android.util.Log;
import com.mytechia.commons.framework.exception.InternalErrorException;
import com.mytechia.robobo.framework.IModule;
import com.mytechia.robobo.framework.LogLvl;
import com.mytechia.robobo.framework.RoboboManager;
import com.mytechia.robobo.framework.remote_control.remotemodule.Command;
import com.mytechia.robobo.framework.remote_control.remotemodule.GsonConverter;
import com.mytechia.robobo.framework.remote_control.remotemodule.IRemoteControlModule;
import com.mytechia.robobo.framework.remote_control.remotemodule.IRemoteControlProxy;
import com.mytechia.robobo.framework.remote_control.remotemodule.Response;
import com.mytechia.robobo.framework.remote_control.remotemodule.Status;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.java_websocket.WebSocket;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class WebsocketRemoteControlModule
implements IRemoteControlProxy,
IModule {
    public static final String PASSWORD = "PASSWORD";
    private RoboboManager roboboManager;
    private String TAG = "Websocket RC Module";
    private HashMap<Integer, WebSocket> connections = new HashMap();
    private HashMap<Integer, WebSocket> connectionsAuthenticated = new HashMap();
    private IRemoteControlModule remoteControlModule;
    private WebSocketServer webSocketServer;
    private int port = 40404;
    private boolean active = false;
    private boolean shuttingDown = false;

    public void notifyStatus(Status status) {
        if (this.active) {
            String jsonStatus = GsonConverter.statusToJson((Status)status);
            this.roboboManager.log(this.TAG, "Status: " + jsonStatus);
            for (Map.Entry<Integer, WebSocket> pair : this.connectionsAuthenticated.entrySet()) {
                WebSocket webSocket = pair.getValue();
                if (webSocket.isClosed()) continue;
                try {
                    webSocket.send(jsonStatus);
                }
                catch (WebsocketNotConnectedException e) {
                    Log.e((String)this.TAG, (String)String.format("Error notifying status: %s", jsonStatus), (Throwable)e);
                    this.roboboManager.log(LogLvl.ERROR, this.TAG, String.format("Error notifying status: %s", jsonStatus));
                }
            }
        }
    }

    public void notifyReponse(Response response) {
        if (this.active) {
            String jsonResponse = GsonConverter.responseToJson((Response)response);
            this.roboboManager.log(this.TAG, "Response: " + jsonResponse);
            for (Map.Entry<Integer, WebSocket> pair : this.connectionsAuthenticated.entrySet()) {
                WebSocket webSocket = pair.getValue();
                if (webSocket.isClosed()) continue;
                try {
                    webSocket.send(jsonResponse);
                }
                catch (WebsocketNotConnectedException e) {
                    Log.e((String)this.TAG, (String)String.format("Error notifying response: %s", jsonResponse), (Throwable)e);
                    this.roboboManager.log(LogLvl.ERROR, this.TAG, String.format("Error notifying response: %s", jsonResponse));
                }
            }
        }
    }

    private synchronized void putSocketConnection(WebSocket conn) {
        this.connections.put(conn.hashCode(), conn);
    }

    private synchronized void putAuthenticatedConnection(WebSocket conn) {
        this.connectionsAuthenticated.put(conn.hashCode(), conn);
    }

    private synchronized void removeSocketConnection(WebSocket conn) {
        this.connections.remove(conn.hashCode());
        this.connectionsAuthenticated.remove(conn.hashCode());
        if (this.connections.size() == 0) {
            this.setActive(false);
        }
    }

    private void setActive(boolean active) {
        this.active = active;
    }

    private void setShuttingDown(boolean shuttingDown) {
        this.shuttingDown = shuttingDown;
        if (this.isShuttingDown()) {
            this.setActive(false);
        }
    }

    private boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public void startup(RoboboManager manager) throws InternalErrorException {
        this.remoteControlModule = (IRemoteControlModule)manager.getModuleInstance(IRemoteControlModule.class);
        if (this.remoteControlModule == null) {
            throw new InternalErrorException("No found instance IRemoteControlModule.");
        }
        this.roboboManager = manager;
        this.remoteControlModule.registerRemoteControlProxy((IRemoteControlProxy)this);
        AssetManager assetManager = manager.getApplicationContext().getAssets();
        Properties properties = new Properties();
        try {
            InputStream inputStream = assetManager.open("remote.properties");
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.webSocketServer = new WebSocketServerImpl(Integer.parseInt(properties.getProperty("wsport", "40404")));
        this.webSocketServer.start();
    }

    public void shutdown() throws InternalErrorException {
        this.setShuttingDown(true);
        try {
            for (Map.Entry<Integer, WebSocket> pair : this.connections.entrySet()) {
                pair.getValue().close();
            }
            this.webSocketServer.stop();
        }
        catch (IOException ex) {
            Log.e((String)this.TAG, (String)String.format("Error closing WebSocketServer", ex));
            this.roboboManager.log(LogLvl.ERROR, this.TAG, "Error closing WebSocketServer");
        }
        catch (InterruptedException ex) {
            this.roboboManager.log(LogLvl.ERROR, this.TAG, "Error closing WebSocketServer. InterruptedException.");
        }
    }

    protected void notifyConnection(int connNumber) {
        if (this.remoteControlModule != null) {
            this.remoteControlModule.notifyConnection(connNumber);
        }
    }

    protected void notifyDisconnection(int connNumber) {
        if (this.remoteControlModule != null) {
            this.remoteControlModule.notifyDisconnection(connNumber);
        }
    }

    public String getModuleInfo() {
        return "WebSocket Remote Control Module";
    }

    public String getModuleVersion() {
        return "0.3.1";
    }

    private class WebSocketServerImpl
    extends WebSocketServer {
        public WebSocketServerImpl(int port) {
            super(new InetSocketAddress(port));
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
            if (!WebsocketRemoteControlModule.this.isShuttingDown()) {
                WebsocketRemoteControlModule.this.putSocketConnection(conn);
                WebsocketRemoteControlModule.this.notifyConnection(conn.hashCode());
                WebsocketRemoteControlModule.this.setActive(true);
                WebsocketRemoteControlModule.this.roboboManager.log(LogLvl.DEBUG, WebsocketRemoteControlModule.this.TAG, String.format("Open websocket connection %s", conn.getRemoteSocketAddress()));
            }
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            if (!WebsocketRemoteControlModule.this.isShuttingDown()) {
                WebsocketRemoteControlModule.this.removeSocketConnection(conn);
                WebsocketRemoteControlModule.this.notifyDisconnection(conn.hashCode());
                WebsocketRemoteControlModule.this.roboboManager.log(LogLvl.DEBUG, WebsocketRemoteControlModule.this.TAG, String.format("Closed websocket connection", new Object[0]));
            }
        }

        public void onMessage(WebSocket webSocketConnection, String message) {
            if (WebsocketRemoteControlModule.this.remoteControlModule == null) {
                return;
            }
            if (message == null || message.length() == 0) {
                return;
            }
            WebsocketRemoteControlModule.this.roboboManager.log(LogLvl.TRACE, WebsocketRemoteControlModule.this.TAG, String.format("Received message:%s|%s| from %s", message, message.substring(10), webSocketConnection.getRemoteSocketAddress()));
            if (message.startsWith(WebsocketRemoteControlModule.PASSWORD)) {
                if (message.substring(10).equals(WebsocketRemoteControlModule.this.remoteControlModule.getPassword())) {
                    WebsocketRemoteControlModule.this.putAuthenticatedConnection(webSocketConnection);
                    WebsocketRemoteControlModule.this.roboboManager.log(LogLvl.DEBUG, WebsocketRemoteControlModule.this.TAG, WebsocketRemoteControlModule.this.connectionsAuthenticated.toString());
                } else {
                    WebsocketRemoteControlModule.this.roboboManager.log(LogLvl.ERROR, WebsocketRemoteControlModule.this.TAG, "Incorrect password");
                    Status statusError = new Status("ERROR");
                    statusError.putContents("error", "Incorrect password");
                    WebsocketRemoteControlModule.this.notifyStatus(statusError);
                    WebsocketRemoteControlModule.this.notifyStatus(new Status("DIE"));
                }
            } else if (WebsocketRemoteControlModule.this.connectionsAuthenticated.containsKey(webSocketConnection.hashCode())) {
                Command command = GsonConverter.jsonToCommand((String)message);
                WebsocketRemoteControlModule.this.remoteControlModule.queueCommand(command);
            }
        }

        public void onError(WebSocket conn, Exception ex) {
            Log.e((String)WebsocketRemoteControlModule.this.TAG, (String)String.format("Error WebSocket[local=%s, remote=%s]", conn.getLocalSocketAddress(), conn.getRemoteSocketAddress()), (Throwable)ex);
            WebsocketRemoteControlModule.this.roboboManager.log(LogLvl.ERROR, WebsocketRemoteControlModule.this.TAG, String.format("Error WebSocket[local=%s, remote=%s]", conn.getLocalSocketAddress(), conn.getRemoteSocketAddress()));
        }
    }
}

