/*
 * Decompiled with CFR 0.152.
 */
package com.mysoftsource.rxandroidauth2.impl;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.GoogleAuthProvider;
import com.mysoftsource.rxandroidauth2.R;
import com.mysoftsource.rxandroidauth2.exception.GoogleAuthException;
import com.mysoftsource.rxandroidauth2.impl.AuthSocialNetwork;
import com.mysoftsource.rxandroidauth2.util.Output;
import com.mysoftsource.rxandroidauth2.util.RxLog;
import io.reactivex.Emitter;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;

public final class GoogleAuthSocialNetwork
extends AuthSocialNetwork {
    private static final int RC_SIGN_IN = 1000;
    private GoogleSignInClient mGoogleSignInClient;
    private final Output<String> mFirebaseIdTokenOutputRelay;
    private final Function<Throwable, Observable<?>> errorMapper = new Function<Throwable, Observable<?>>(){

        public Observable<?> apply(Throwable throwable) throws Exception {
            return Observable.error((Throwable)throwable);
        }
    };

    public GoogleAuthSocialNetwork(Activity activity) {
        super(activity);
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).requestIdToken(activity.getString(R.string.default_web_client_id)).requestEmail().build();
        this.mGoogleSignInClient = GoogleSignIn.getClient((Activity)activity, (GoogleSignInOptions)gso);
        this.mFirebaseIdTokenOutputRelay = new Output();
    }

    @Override
    protected Observable<String> requestLogin() {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> emitter) throws Exception {
                final Disposable disposable = GoogleAuthSocialNetwork.this.withErrorHandling(GoogleAuthSocialNetwork.this.mFirebaseIdTokenOutputRelay).take(1L).subscribe((Consumer)new Consumer<String>(){

                    public void accept(String s) throws Exception {
                        emitter.onNext((Object)s);
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    public void accept(Throwable throwable) throws Exception {
                        emitter.onError(throwable);
                    }
                }, new Action(){

                    public void run() throws Exception {
                        emitter.onComplete();
                    }
                });
                Intent signInIntent = GoogleAuthSocialNetwork.this.mGoogleSignInClient.getSignInIntent();
                GoogleAuthSocialNetwork.this.mActivity.startActivityForResult(signInIntent, 1000);
                emitter.setCancellable(new Cancellable(){

                    public void cancel() throws Exception {
                        disposable.dispose();
                    }
                });
            }
        });
    }

    @Override
    protected Observable<Boolean> requestLogout() {
        return Observable.create(emitter -> this.mGoogleSignInClient.signOut().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                RxLog.d("requestLogout>> google is signOut", new Object[0]);
                emitter.onNext((Object)task.isSuccessful());
                emitter.onComplete();
            }
        }));
    }

    @Override
    protected boolean isLoggedIn() {
        return GoogleSignIn.getLastSignedInAccount((Context)this.mActivity) != null;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1000 && this.mFirebaseIdTokenOutputRelay.hasObservers()) {
            if (resultCode == 0) {
                this.mFirebaseIdTokenOutputRelay.errorRelay.accept((Object)new GoogleAuthException("Google sign in cancel", GoogleAuthException.Reason.CANCEL));
                return;
            }
            Task task = GoogleSignIn.getSignedInAccountFromIntent((Intent)data);
            try {
                RxLog.d("Google Sign In was successful, authenticate with Firebase", new Object[0]);
                GoogleSignInAccount account = (GoogleSignInAccount)task.getResult(ApiException.class);
                this.firebaseAuthWithGoogle(account).subscribe(idToken -> this.mFirebaseIdTokenOutputRelay.valueRelay.accept(idToken), throwable -> this.mFirebaseIdTokenOutputRelay.errorRelay.accept((Object)new GoogleAuthException("firebase auth failed", (Throwable)throwable)));
            }
            catch (ApiException e) {
                RxLog.e(e, "Google sign in failed", new Object[0]);
                this.mFirebaseIdTokenOutputRelay.errorRelay.accept((Object)new GoogleAuthException("Google sign in failed", e));
            }
        }
    }

    private Observable<String> firebaseAuthWithGoogle(final GoogleSignInAccount account) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(ObservableEmitter<String> emitter) throws Exception {
                RxLog.d("firebaseAuthWithGoogle>> token = %s", account.getIdToken());
                AuthCredential credential = GoogleAuthProvider.getCredential((String)account.getIdToken(), null);
                GoogleAuthSocialNetwork.this.handleSocialNetworkAccessToken(credential, (Emitter<String>)emitter);
            }
        });
    }

    private <T> Observable<T> withErrorHandling(Output<T> output) {
        return Observable.merge(output.valueRelay, (ObservableSource)output.errorRelay.flatMap(this.errorMapper));
    }
}

