/*
 * Decompiled with CFR 0.152.
 */
package com.mysoftsource.rxandroidauth2.impl;

import android.app.Activity;
import android.content.Intent;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FacebookAuthProvider;
import com.mysoftsource.rxandroidauth2.exception.FacebookAuthException;
import com.mysoftsource.rxandroidauth2.impl.AuthSocialNetwork;
import com.mysoftsource.rxandroidauth2.util.RxLog;
import io.reactivex.Emitter;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Cancellable;
import java.util.Arrays;

public final class FacebookAuthSocialNetwork
extends AuthSocialNetwork {
    private CallbackManager mCallbackManager = CallbackManager.Factory.create();

    public FacebookAuthSocialNetwork(Activity activity) {
        super(activity);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mCallbackManager.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    protected Observable<String> requestLogin() {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> emitter) throws Exception {
                LoginManager.getInstance().registerCallback(FacebookAuthSocialNetwork.this.mCallbackManager, (FacebookCallback)new FacebookCallback<LoginResult>(){

                    public void onSuccess(LoginResult loginResult) {
                        RxLog.d("facebook:onSuccess: %s", loginResult.getAccessToken().getToken());
                        AuthCredential credential = FacebookAuthProvider.getCredential((String)loginResult.getAccessToken().getToken());
                        FacebookAuthSocialNetwork.this.handleSocialNetworkAccessToken(credential, (Emitter<String>)emitter);
                    }

                    public void onCancel() {
                        RxLog.d("facebook:onCancel", new Object[0]);
                        emitter.onError((Throwable)new FacebookAuthException("facebook:onCancel", FacebookAuthException.Reason.CANCEL));
                    }

                    public void onError(FacebookException error) {
                        RxLog.e((Throwable)error, "facebook:onError", new Object[0]);
                        emitter.onError((Throwable)new FacebookAuthException("facebook:onError", (Throwable)error));
                    }
                });
                LoginManager.getInstance().logInWithReadPermissions(FacebookAuthSocialNetwork.this.mActivity, Arrays.asList("email", "public_profile"));
                emitter.setCancellable(new Cancellable(){

                    public void cancel() throws Exception {
                        LoginManager.getInstance().unregisterCallback(FacebookAuthSocialNetwork.this.mCallbackManager);
                    }
                });
            }
        });
    }

    @Override
    protected Observable<Boolean> requestLogout() {
        LoginManager.getInstance().logOut();
        return Observable.just((Object)true);
    }

    @Override
    protected boolean isLoggedIn() {
        return AccessToken.getCurrentAccessToken() != null;
    }
}

