/*
 * Decompiled with CFR 0.152.
 */
package com.mysoftsource.rxandroidauth2;

import android.app.Activity;
import android.content.Intent;
import com.mysoftsource.rxandroidauth2.exception.RxAuthException;
import com.mysoftsource.rxandroidauth2.impl.AuthSocialNetwork;
import com.mysoftsource.rxandroidauth2.impl.FacebookAuthSocialNetwork;
import com.mysoftsource.rxandroidauth2.impl.GoogleAuthSocialNetwork;
import com.mysoftsource.rxandroidauth2.util.RxLog;
import io.reactivex.Observable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AuthHelper {
    private Map<SocialNetworkType, AuthSocialNetwork> SOCIAL_NETWORKS;

    public AuthHelper(Map<SocialNetworkType, AuthSocialNetwork> socialNetworkMap) {
        this.SOCIAL_NETWORKS = socialNetworkMap;
    }

    public Observable<String> login(SocialNetworkType type) {
        if (!this.SOCIAL_NETWORKS.containsKey((Object)type)) {
            throw new RxAuthException(String.format(Locale.US, "%s wasn't initialized... in AuthHelper.Builder", type.toString()));
        }
        if (this.isNotAuthAvailable()) {
            return Observable.error((Throwable)new RxAuthException("contain auth is busy, please check logic"));
        }
        return this.SOCIAL_NETWORKS.get((Object)type).login();
    }

    public Observable<Boolean> logout(SocialNetworkType type) {
        if (!this.SOCIAL_NETWORKS.containsKey((Object)type)) {
            throw new RxAuthException(String.format(Locale.US, "%s wasn't initialized... in AuthHelper.Builder", type.toString()));
        }
        if (this.isNotAuthAvailable()) {
            return Observable.error((Throwable)new RxAuthException("contain auth is busy, please check logic"));
        }
        return this.SOCIAL_NETWORKS.get((Object)type).logout();
    }

    public Observable<Boolean> logout() {
        if (this.SOCIAL_NETWORKS.isEmpty()) {
            throw new RxAuthException("no function initialized... in AuthHelper.Builder");
        }
        if (this.isNotAuthAvailable()) {
            return Observable.error((Throwable)new RxAuthException("contain auth is busy, please check logic"));
        }
        return Observable.fromIterable(this.SOCIAL_NETWORKS.values()).concatMap(authSocialNetwork -> authSocialNetwork.logout()).doOnNext(success -> RxLog.d("logout is success %b", success));
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        for (AuthSocialNetwork authSocialNetwork : this.SOCIAL_NETWORKS.values()) {
            authSocialNetwork.onActivityResult(requestCode, resultCode, data);
        }
    }

    private boolean isNotAuthAvailable() {
        boolean isAuthBusy = false;
        for (Map.Entry<SocialNetworkType, AuthSocialNetwork> entry : this.SOCIAL_NETWORKS.entrySet()) {
            if (!entry.getValue().isAuthBusy()) continue;
            RxLog.d("isNotAuthAvailable>> %s is busy", entry.getKey().toString());
            isAuthBusy = true;
        }
        return isAuthBusy;
    }

    public static class Builder {
        private Map<SocialNetworkType, AuthSocialNetwork> socialNetworkMap = new HashMap<SocialNetworkType, AuthSocialNetwork>();
        private Activity activity;

        public Builder from(Activity activity) {
            this.activity = activity;
            return this;
        }

        public Builder facebook() {
            this.checkValidInput();
            if (this.socialNetworkMap.containsKey((Object)SocialNetworkType.FACEBOOK)) {
                throw new RxAuthException("FACEBOOK type already logged");
            }
            this.socialNetworkMap.put(SocialNetworkType.FACEBOOK, new FacebookAuthSocialNetwork(this.activity));
            return this;
        }

        public Builder google() {
            this.checkValidInput();
            if (this.socialNetworkMap.containsKey((Object)SocialNetworkType.GOOGLE)) {
                throw new RxAuthException("GOOGLE type already logged");
            }
            this.socialNetworkMap.put(SocialNetworkType.GOOGLE, new GoogleAuthSocialNetwork(this.activity));
            return this;
        }

        public AuthHelper build() {
            if (this.socialNetworkMap.isEmpty()) {
                throw new RxAuthException("no social network is chosen");
            }
            AuthHelper authHelper = new AuthHelper(this.socialNetworkMap);
            return authHelper;
        }

        private void checkValidInput() {
            if (this.activity == null) {
                throw new RxAuthException("Please call from() method before all");
            }
        }
    }

    public static enum SocialNetworkType {
        FACEBOOK,
        GOOGLE;

    }
}

