package com.mysoftsource.rxandroidauth2.exception;

public class FacebookAuthException extends RxAuthException {
    public enum Reason {
        CANCEL,
        ERROR
    }
    private Reason mReason;

    public FacebookAuthException(String message) {
        super(message);
        mReason = Reason.ERROR;
    }

    public FacebookAuthException(String message, Reason reason) {
        super(message);
        mReason = reason;
    }

    public FacebookAuthException(String message, Throwable cause) {
        super(message, cause);
        mReason = Reason.ERROR;
    }

    public Reason getReason() {
        return mReason;
    }

    @Override
    public String toString() {
        return "FacebookAuthException { "
                + "Reason = " + mReason.toString()
                + ", "
                + toStringCauseIfExists()
                + '}';
    }
}
