/*
 * Decompiled with CFR 0.152.
 */
package com.mysoftsource.rxandroidauth2.util;

import android.support.annotation.Nullable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RxLog {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int NONE = Integer.MAX_VALUE;
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile("\\$\\d+$");
    private static final ThreadLocal<String> NEXT_TAG = new ThreadLocal();
    private static Logger logcatLogger = new Logger(){

        @Override
        public void log(int level, String tag, String msg) {
            Log.println((int)level, (String)tag, (String)msg);
        }
    };
    private static int logLevel = Integer.MAX_VALUE;
    private static Logger logger = logcatLogger;

    private RxLog() {
    }

    public static void setLogger(@Nullable Logger logger) {
        RxLog.logger = logger == null ? logcatLogger : logger;
    }

    public static void setLogLevel(int logLevel) {
        RxLog.logLevel = logLevel;
    }

    private static String createTag() {
        String tag = NEXT_TAG.get();
        if (tag != null) {
            NEXT_TAG.remove();
            return tag;
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (stackTrace.length < 5) {
            throw new IllegalStateException("Synthetic stacktrace didn't have enough elements: are you using proguard?");
        }
        tag = stackTrace[4].getClassName();
        Matcher m = ANONYMOUS_CLASS.matcher(tag);
        if (m.find()) {
            tag = m.replaceAll("");
        }
        tag = tag.replace("Impl", "");
        tag = tag.replace("RxLog", "");
        return "RxLog#" + tag.substring(tag.lastIndexOf(46) + 1);
    }

    private static String formatString(String message, Object ... args) {
        return args.length == 0 ? message : String.format(message, args);
    }

    public static void v(String message, Object ... args) {
        RxLog.throwShade(2, null, message, args);
    }

    public static void v(Throwable t, String message, Object ... args) {
        RxLog.throwShade(2, t, message, args);
    }

    public static void d(String message, Object ... args) {
        RxLog.throwShade(3, null, message, args);
    }

    public static void d(Throwable t, String message, Object ... args) {
        RxLog.throwShade(3, t, message, args);
    }

    public static void i(String message, Object ... args) {
        RxLog.throwShade(4, null, message, args);
    }

    public static void i(Throwable t, String message, Object ... args) {
        RxLog.throwShade(4, t, message, args);
    }

    public static void w(String message, Object ... args) {
        RxLog.throwShade(5, null, message, args);
    }

    public static void w(Throwable t, String message, Object ... args) {
        RxLog.throwShade(5, t, message, args);
    }

    public static void e(String message, Object ... args) {
        RxLog.throwShade(6, null, message, args);
    }

    public static void e(Throwable t, String message, Object ... args) {
        RxLog.throwShade(6, t, message, args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void throwShade(int priority, Throwable t, String message, Object ... args) {
        String finalMessage;
        if (priority < logLevel) {
            return;
        }
        String formattedMessage = RxLog.formatString(message, args);
        if (formattedMessage == null || formattedMessage.length() == 0) {
            if (t == null) return;
            finalMessage = Log.getStackTraceString((Throwable)t);
        } else {
            finalMessage = t != null ? formattedMessage + "\n" + Log.getStackTraceString((Throwable)t) : formattedMessage;
        }
        String tag = RxLog.createTag();
        RxLog.println(priority, tag, finalMessage);
    }

    private static void println(int priority, String tag, String message) {
        if (message.length() < 4000) {
            logger.log(priority, tag, message);
        } else {
            String[] lines;
            for (String line : lines = message.split("\n")) {
                logger.log(priority, tag, line);
            }
        }
    }

    public static boolean isAtLeast(int expectedLogLevel) {
        return logLevel <= expectedLogLevel;
    }

    public static interface Logger {
        public void log(int var1, String var2, String var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

