/*
 * Decompiled with CFR 0.152.
 */
package com.mysoftsource.rxandroidauth2.impl;

import android.app.Activity;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.mysoftsource.rxandroidauth2.exception.RxAuthException;
import com.mysoftsource.rxandroidauth2.util.RxLog;
import io.reactivex.Emitter;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public abstract class AuthSocialNetwork {
    protected FirebaseAuth mFirebaseAuthAuth = FirebaseAuth.getInstance();
    protected Activity mActivity;
    private boolean mIsLoginBusy;
    private boolean mIsLogoutBusy;

    AuthSocialNetwork(Activity activity) {
        this.mActivity = activity;
        this.mIsLoginBusy = false;
        this.mIsLogoutBusy = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public Observable<String> login() {
        return this.requestLogoutIfNeed().flatMap(success -> {
            RxLog.d("login>> request login", new Object[0]);
            return this.requestLogin();
        }).doOnSubscribe((Consumer)new Consumer<Disposable>(){

            public void accept(Disposable disposable) throws Exception {
                RxLog.d("login>> doOnSubscribe", new Object[0]);
                AuthSocialNetwork.this.mIsLoginBusy = true;
            }
        }).doFinally(() -> {
            RxLog.d("login>> doFinally", new Object[0]);
            this.mIsLoginBusy = false;
        });
    }

    public Observable<Boolean> logout() {
        RxLog.d("logout>> request logout", new Object[0]);
        return this.requestLogout().doOnNext(success -> this.mFirebaseAuthAuth.signOut()).doOnSubscribe((Consumer)new Consumer<Disposable>(){

            public void accept(Disposable disposable) throws Exception {
                RxLog.d("logout>> doOnSubscribe", new Object[0]);
                AuthSocialNetwork.this.mIsLoginBusy = true;
            }
        }).doFinally(() -> {
            RxLog.d("logout>> doFinally", new Object[0]);
            this.mIsLoginBusy = false;
        });
    }

    public boolean isAuthBusy() {
        return this.mIsLoginBusy || this.mIsLogoutBusy;
    }

    protected abstract Observable<String> requestLogin();

    protected abstract Observable<Boolean> requestLogout();

    protected abstract boolean isLoggedIn();

    protected void handleSocialNetworkAccessToken(AuthCredential credential, final Emitter<String> emitter) {
        RxLog.d("handleSocialNetworkAccessToken>> start signInWithCredential", new Object[0]);
        this.mFirebaseAuthAuth.signInWithCredential(credential).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<AuthResult>(){

            public void onComplete(@NonNull Task<AuthResult> task) {
                if (task.isSuccessful()) {
                    RxLog.d("signInWithCredential:success", new Object[0]);
                    FirebaseUser user = AuthSocialNetwork.this.mFirebaseAuthAuth.getCurrentUser();
                    AuthSocialNetwork.this.handleFirebaseIdToken(user, (Emitter<String>)emitter);
                } else {
                    RxLog.e(task.getException(), "signInWithCredential:failure", new Object[0]);
                    emitter.onError((Throwable)new RxAuthException(task.getException()));
                }
            }
        });
    }

    private void handleFirebaseIdToken(FirebaseUser user, final Emitter<String> emitter) {
        RxLog.d("handleFirebaseAccessToken>> email = %s", user.getEmail());
        RxLog.d("handleFirebaseAccessToken>> Uid = %s", user.getUid());
        user.getIdToken(true).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<GetTokenResult>(){

            public void onComplete(@NonNull Task<GetTokenResult> task) {
                if (task.isSuccessful()) {
                    String idToken = ((GetTokenResult)task.getResult()).getToken();
                    RxLog.d("handleFirebaseIdToken>> idToken = %s", idToken);
                    emitter.onNext((Object)idToken);
                    emitter.onComplete();
                } else {
                    RxLog.e(task.getException(), "handleFirebaseIdToken>> get idToken is failed", new Object[0]);
                    emitter.onError((Throwable)new RxAuthException(task.getException()));
                }
            }
        });
    }

    private Observable<Boolean> requestLogoutIfNeed() {
        if (this.isLoggedIn()) {
            RxLog.d("Already logged, please check isLoggedIn() method", new Object[0]);
            return this.requestLogout().doOnNext(success -> this.mFirebaseAuthAuth.signOut());
        }
        return Observable.just((Object)true);
    }
}

