package com.mysoftsource.rxandroidauth2.exception;

public class GoogleAuthException extends RxAuthException {
    public enum Reason {
        CANCEL,
        ERROR
    }
    private Reason mReason;

    public GoogleAuthException(String message) {
        super(message);
        mReason = Reason.ERROR;
    }

    public GoogleAuthException(String message, Reason reason) {
        super(message);
        mReason = reason;
    }

    public GoogleAuthException(String message, Throwable cause) {
        super(message, cause);
        mReason = Reason.ERROR;
    }

    public Reason getReason() {
        return mReason;
    }

    @Override
    public String toString() {
        return "FacebookAuthException { "
                + "Reason = " + mReason.toString()
                + ", "
                + toStringCauseIfExists()
                + '}';
    }
}