/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.mysema.query.sql.AbstractSQLSubQuery;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.DetachableSQLQuery;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLCommonQuery;
import com.mysema.query.sql.SQLCommonQueryFactory;
import com.mysema.query.sql.SQLSubQuery;
import com.mysema.query.sql.dml.SQLDeleteClause;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.sql.dml.SQLMergeClause;
import com.mysema.query.sql.dml.SQLUpdateClause;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQueryExpression;
import java.sql.Connection;
import javax.inject.Provider;

@BridgeMethodsAdded
public abstract class AbstractSQLQueryFactory<Q extends SQLCommonQuery<Q>, SQ extends AbstractSQLSubQuery<SQ>>
implements SQLCommonQueryFactory<Q, SQ, SQLDeleteClause, SQLUpdateClause, SQLInsertClause, SQLMergeClause> {
    protected final Configuration configuration;
    protected final Provider<Connection> connection;

    public AbstractSQLQueryFactory(Configuration configuration, Provider<Connection> connection) {
        this.configuration = configuration;
        this.connection = connection;
    }

    @Override
    public final SQLDeleteClause delete(RelationalPath<?> path) {
        return new SQLDeleteClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final Q from(Expression<?> from) {
        return this.query().from(from);
    }

    @Override
    public final Q from(Expression<?> ... args) {
        return this.query().from(args);
    }

    @Override
    public final Q from(SubQueryExpression<?> subQuery, Path<?> alias) {
        return this.query().from(subQuery, alias);
    }

    @Override
    public final SQLInsertClause insert(RelationalPath<?> path) {
        return new SQLInsertClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final SQLMergeClause merge(RelationalPath<?> path) {
        return new SQLMergeClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    public final SQLUpdateClause update(RelationalPath<?> path) {
        return new SQLUpdateClause((Connection)this.connection.get(), this.configuration, path);
    }

    @Override
    @WithBridgeMethods(value={SQLSubQuery.class}, castRequired=true)
    public SQ subQuery() {
        return (SQ)new SQLSubQuery();
    }

    @Override
    @WithBridgeMethods(value={SQLSubQuery.class}, castRequired=true)
    public final SQ subQuery(Expression<?> from) {
        return (SQ)((AbstractSQLSubQuery)((DetachableSQLQuery)this.subQuery()).from(from));
    }

    public final Configuration getConfiguration() {
        return this.configuration;
    }

    public final Connection getConnection() {
        return (Connection)this.connection.get();
    }
}

