/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.postgres;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.AbstractSQLQuery;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.PostgresTemplates;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.SQLTemplates;
import java.sql.Connection;

public class PostgresQuery
extends AbstractSQLQuery<PostgresQuery> {
    public PostgresQuery(Connection conn) {
        this(conn, new Configuration(new PostgresTemplates()), (QueryMetadata)new DefaultQueryMetadata());
    }

    public PostgresQuery(Connection conn, SQLTemplates templates) {
        this(conn, new Configuration(templates), (QueryMetadata)new DefaultQueryMetadata());
    }

    public PostgresQuery(Connection conn, Configuration configuration) {
        this(conn, configuration, (QueryMetadata)new DefaultQueryMetadata());
    }

    public PostgresQuery(Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(conn, configuration, metadata);
    }

    public PostgresQuery forShare() {
        return (PostgresQuery)this.addFlag(SQLOps.FOR_SHARE_FLAG);
    }

    public PostgresQuery noWait() {
        return (PostgresQuery)this.addFlag(SQLOps.NO_WAIT_FLAG);
    }

    public PostgresQuery of(RelationalPath<?> ... paths) {
        StringBuilder builder = new StringBuilder(" of ");
        for (RelationalPath<?> path : paths) {
            if (builder.length() > 4) {
                builder.append(", ");
            }
            builder.append(this.getConfiguration().getTemplates().quoteIdentifier(path.getTableName()));
        }
        return (PostgresQuery)this.addFlag(QueryFlag.Position.END, builder.toString());
    }
}

