/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.oracle.OracleTemplates;
import com.mysema.query.types.operation.Ops;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class SQLTemplatesFactory {
    private static final SQLTemplates defaultTemplates = new SQLTemplates();
    private static final SQLTemplates derbyTemplates = new SQLTemplates(){
        {
            this.add(Ops.CONCAT, "{0} || {1}");
            this.add(Ops.MathOps.ROUND, "floor({0})");
            this.add(Ops.SUBSTR_1ARG, "substr({0},{1}+1)");
            this.add(Ops.SUBSTR_2ARGS, "substr({0},{1}+1,{2}+1)");
            this.add(Ops.STARTS_WITH, "{0} like ({1} || '%')");
            this.add(Ops.ENDS_WITH, "{0} like ('%' || {1})");
            this.add(Ops.STARTS_WITH_IC, "lower({0}) like (lower({1}) || '%')");
            this.add(Ops.ENDS_WITH_IC, "lower({0}) like ('%' || lower({1}))");
            this.add(Ops.DateTimeOps.YEAR, "year({0})");
            this.add(Ops.DateTimeOps.MONTH, "month({0})");
            this.add(Ops.DateTimeOps.HOUR, "hour({0})");
            this.add(Ops.DateTimeOps.MINUTE, "minute({0})");
            this.add(Ops.DateTimeOps.SECOND, "second({0})");
        }
    };
    private static final SQLTemplates hsqldbTemplates = new SQLTemplates(){
        {
            this.add(Ops.MathOps.ROUND, "round({0},0)");
            this.add(Ops.TRIM, "trim(both from {0})");
        }
    };
    private static final SQLTemplates mysqlTemplates = new SQLTemplates(){
        {
            this.addClass2TypeMappings("signed", Byte.class, Integer.class, Long.class, Short.class, BigInteger.class);
            this.addClass2TypeMappings("decimal", Double.class, Float.class, BigDecimal.class);
            this.addClass2TypeMappings("char(256)", String.class);
        }
    };
    private static final SQLTemplates oracleTemplates = new OracleTemplates();

    private SQLTemplatesFactory() {
    }

    public static SQLTemplates forDerby() {
        return derbyTemplates;
    }

    public static SQLTemplates forHSQLDB() {
        return hsqldbTemplates;
    }

    public static SQLTemplates forMySQL() {
        return mysqlTemplates;
    }

    public static SQLTemplates forOracle() {
        return oracleTemplates;
    }

    public static SQLTemplates forOracle10() {
        return oracleTemplates;
    }

    public static SQLTemplates forPostgreSQL() {
        return defaultTemplates;
    }

    public static SQLTemplates forSQLServer() {
        return defaultTemplates;
    }
}

