/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.JoinExpression;
import com.mysema.query.QueryMetadata;
import com.mysema.query.serialization.SerializerBase;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.SumOver;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Templates;
import com.mysema.query.types.expr.Constant;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EConstructor;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.operation.Operator;
import com.mysema.query.types.operation.Ops;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.query.SubQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SQLSerializer
extends SerializerBase<SQLSerializer> {
    private final List<Object> constants = new ArrayList<Object>();
    protected final SQLTemplates templates;

    public SQLSerializer(SQLTemplates templates) {
        super((Templates)templates);
        this.templates = templates;
    }

    protected void beforeOrderBy() {
    }

    public List<Object> getConstants() {
        return this.constants;
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow) {
        List select = metadata.getProjection();
        List joins = metadata.getJoins();
        EBoolean where = metadata.getWhere();
        List groupBy = metadata.getGroupBy();
        EBoolean having = metadata.getHaving();
        List orderBy = metadata.getOrderBy();
        if (forCountRow) {
            ((SQLSerializer)this.append(new String[]{this.templates.select()})).append(new String[]{this.templates.countStar()});
        } else if (!select.isEmpty()) {
            if (!metadata.isDistinct()) {
                this.append(new String[]{this.templates.select()});
            } else {
                this.append(new String[]{this.templates.selectDistinct()});
            }
            ArrayList<Expr> sqlSelect = new ArrayList<Expr>();
            for (Expr selectExpr : select) {
                if (selectExpr instanceof EConstructor) {
                    sqlSelect.addAll(((EConstructor)selectExpr).getArgs());
                    continue;
                }
                sqlSelect.add(selectExpr);
            }
            this.handle(", ", sqlSelect);
        }
        this.append(new String[]{this.templates.from()});
        if (joins.isEmpty()) {
            this.append(new String[]{this.templates.dummyTable()});
        }
        for (int i = 0; i < joins.size(); ++i) {
            PEntity pe;
            JoinExpression je = (JoinExpression)joins.get(i);
            if (i > 0) {
                String sep = ", ";
                switch (je.getType()) {
                    case FULLJOIN: {
                        sep = this.templates.fullJoin();
                        break;
                    }
                    case INNERJOIN: {
                        sep = this.templates.innerJoin();
                        break;
                    }
                    case JOIN: {
                        sep = this.templates.join();
                        break;
                    }
                    case LEFTJOIN: {
                        sep = this.templates.leftJoin();
                    }
                }
                this.append(new String[]{sep});
            }
            if (je.getTarget() instanceof PEntity && this.templates.supportsAlias() && (pe = (PEntity)je.getTarget()).getMetadata().getParent() == null) {
                ((SQLSerializer)this.append(new String[]{pe.getEntityName()})).append(new String[]{this.templates.tableAlias()});
            }
            this.handle(je.getTarget());
            if (je.getCondition() == null) continue;
            ((SQLSerializer)this.append(new String[]{this.templates.on()})).handle((Expr)je.getCondition());
        }
        if (where != null) {
            ((SQLSerializer)this.append(new String[]{this.templates.where()})).handle((Expr)where);
        }
        if (!groupBy.isEmpty()) {
            ((SQLSerializer)this.append(new String[]{this.templates.groupBy()})).handle(", ", groupBy);
        }
        if (having != null) {
            if (groupBy.isEmpty()) {
                throw new IllegalArgumentException("having, but not groupBy was given");
            }
            ((SQLSerializer)this.append(new String[]{this.templates.having()})).handle((Expr)having);
        }
        this.beforeOrderBy();
        Long limit = metadata.getModifiers().getLimit();
        Long offset = metadata.getModifiers().getOffset();
        if (!this.templates.limitAndOffsetSymbols() && metadata.getModifiers().isRestricting() && !forCountRow) {
            if (where == null) {
                this.append(new String[]{this.templates.where()});
            }
            this.append(new String[]{this.templates.limitOffsetCondition(limit, offset)});
        }
        if (!orderBy.isEmpty() && !forCountRow) {
            this.append(new String[]{this.templates.orderBy()});
            boolean first = true;
            for (OrderSpecifier os : orderBy) {
                if (!first) {
                    this.append(new String[]{", "});
                }
                this.handle(os.getTarget());
                this.append(new String[]{os.getOrder() == Order.ASC ? this.templates.asc() : this.templates.desc()});
                first = false;
            }
        }
        if (this.templates.limitAndOffsetSymbols() && metadata.getModifiers().isRestricting() && !forCountRow) {
            if (limit != null) {
                ((SQLSerializer)this.append(new String[]{this.templates.limit()})).append(new String[]{String.valueOf(limit)});
            }
            if (offset != null) {
                ((SQLSerializer)this.append(new String[]{this.templates.offset()})).append(new String[]{String.valueOf(offset)});
            }
        }
    }

    public void serializeUnion(SubQuery[] sqs, List<OrderSpecifier<?>> orderBy) {
        this.handle(this.templates.union(), Arrays.asList(sqs));
        if (!orderBy.isEmpty()) {
            this.append(new String[]{this.templates.orderBy()});
            boolean first = true;
            for (OrderSpecifier<?> os : orderBy) {
                if (!first) {
                    this.append(new String[]{", "});
                }
                this.handle(os.getTarget());
                this.append(new String[]{os.getOrder() == Order.ASC ? this.templates.asc() : this.templates.desc()});
                first = false;
            }
        }
    }

    public void visit(Constant<?> expr) {
        this.append(new String[]{"?"});
        this.constants.add(expr.getConstant());
    }

    private void visitCast(Operator<?> operator, Expr<?> source, Class<?> targetType) {
        ((SQLSerializer)this.append(new String[]{"cast("})).handle(source);
        this.append(new String[]{" as "});
        ((SQLSerializer)this.append(new String[]{this.templates.getClass2Type().get(targetType)})).append(new String[]{")"});
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<Expr<?>> args) {
        if (operator.equals((Object)Ops.STRING_CAST)) {
            this.visitCast(operator, args.get(0), String.class);
        } else if (operator.equals((Object)Ops.NUMCAST)) {
            this.visitCast(operator, args.get(0), (Class)((Constant)args.get(1)).getConstant());
        } else {
            super.visitOperation(type, operator, args);
        }
    }

    public void visit(SubQuery query) {
        this.append(new String[]{"("});
        this.serialize(query.getMetadata(), false);
        this.append(new String[]{")"});
    }

    public void visit(SumOver<?> expr) {
        ((SQLSerializer)((SQLSerializer)((SQLSerializer)this.append(new String[]{this.templates.sum()})).append(new String[]{"("})).handle(expr.getTarget())).append(new String[]{") "});
        this.append(new String[]{this.templates.over()});
        this.append(new String[]{" ("});
        if (expr.getPartitionBy() != null) {
            ((SQLSerializer)this.append(new String[]{this.templates.partitionBy()})).handle(expr.getPartitionBy());
        }
        if (!expr.getOrderBy().isEmpty()) {
            ((SQLSerializer)this.append(new String[]{this.templates.orderBy()})).handle(", ", expr.getOrderBy());
        }
        this.append(new String[]{")"});
    }
}

