/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.codegen.ClassModel;
import com.mysema.query.codegen.ClassModelFactory;
import com.mysema.query.codegen.FieldModel;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.Serializers;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import com.mysema.query.codegen.TypeModelFactory;
import com.mysema.query.util.FileUtils;
import java.io.File;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MetaDataExporter {
    private final Map<Integer, Class<?>> sqlToJavaType = new HashMap();
    private final String namePrefix;
    private final String targetFolder;
    private final String packageName;
    private final String schemaPattern;
    private final String tableNamePattern;
    private static final Serializer serializer = Serializers.DOMAIN;

    public MetaDataExporter(String namePrefix, String packageName, String schemaPattern, String tableNamePattern, String targetFolder) {
        this.namePrefix = namePrefix;
        this.packageName = packageName;
        this.schemaPattern = schemaPattern;
        this.tableNamePattern = tableNamePattern;
        this.targetFolder = targetFolder;
        this.sqlToJavaType.put(-7, Boolean.class);
        this.sqlToJavaType.put(16, Boolean.class);
        this.sqlToJavaType.put(-5, Long.class);
        this.sqlToJavaType.put(8, Double.class);
        this.sqlToJavaType.put(4, Integer.class);
        this.sqlToJavaType.put(5, Short.class);
        this.sqlToJavaType.put(-6, Byte.class);
        this.sqlToJavaType.put(6, Float.class);
        this.sqlToJavaType.put(7, Float.class);
        this.sqlToJavaType.put(2, BigDecimal.class);
        this.sqlToJavaType.put(3, BigDecimal.class);
        this.sqlToJavaType.put(91, Date.class);
        this.sqlToJavaType.put(92, Time.class);
        this.sqlToJavaType.put(93, Date.class);
        this.sqlToJavaType.put(1, Character.class);
        this.sqlToJavaType.put(2005, String.class);
        this.sqlToJavaType.put(12, String.class);
        this.sqlToJavaType.put(-1, String.class);
        this.sqlToJavaType.put(0, Object.class);
        this.sqlToJavaType.put(1111, Object.class);
        this.sqlToJavaType.put(7, Object.class);
        this.sqlToJavaType.put(2006, Object.class);
        this.sqlToJavaType.put(2002, Object.class);
        this.sqlToJavaType.put(2000, Object.class);
        this.sqlToJavaType.put(-2, Object.class);
        this.sqlToJavaType.put(-4, Object.class);
        this.sqlToJavaType.put(-3, Object.class);
        this.sqlToJavaType.put(2004, Object.class);
    }

    public void export(DatabaseMetaData md) throws SQLException {
        if (this.targetFolder == null) {
            throw new IllegalArgumentException("targetFolder needs to be set");
        }
        if (this.packageName == null) {
            throw new IllegalArgumentException("packageName needs to be set");
        }
        ResultSet tables = md.getTables(null, this.schemaPattern, this.tableNamePattern, null);
        ClassModelFactory factory = new ClassModelFactory(new TypeModelFactory(new Class[0]));
        while (tables.next()) {
            String tableName = tables.getString(3);
            ClassModel classModel = new ClassModel(factory, this.namePrefix, null, "java.lang", "java.lang.Object", tableName);
            ResultSet columns = md.getColumns(null, this.schemaPattern, tables.getString(3), null);
            while (columns.next()) {
                String name = columns.getString(4);
                Class<?> clazz = this.sqlToJavaType.get(columns.getInt(5));
                if (clazz == null) {
                    throw new RuntimeException("No java type for " + columns.getString(6));
                }
                TypeCategory fieldType = TypeCategory.COMPARABLE;
                if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                    fieldType = TypeCategory.BOOLEAN;
                } else if (clazz.equals(String.class)) {
                    fieldType = TypeCategory.STRING;
                }
                TypeModel typeModel = new TypeModel(fieldType, clazz.getName(), clazz.getPackage().getName(), clazz.getSimpleName(), null, null);
                classModel.addField(new FieldModel(classModel, name, typeModel, name));
            }
            columns.close();
            this.serialize(classModel);
        }
        tables.close();
    }

    private void serialize(ClassModel type) {
        try {
            String path = this.packageName.replace('.', '/') + "/" + this.namePrefix + type.getSimpleName() + ".java";
            serializer.serialize(type, FileUtils.writerFor((File)new File(this.targetFolder, path)));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

