/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.Union;
import com.mysema.query.support.QueryBaseWithProjection;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.EConstructor;
import com.mysema.query.types.expr.Expr;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.query.types.query.ObjectSubQuery;
import com.mysema.query.types.query.SubQuery;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSQLQuery<SubType extends AbstractSQLQuery<SubType>>
extends QueryBaseWithProjection<SubType> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSQLQuery.class);
    private String queryString;
    private List<Object> constants;
    private final Connection conn;
    protected final SQLTemplates templates;
    private SubQuery[] sq;

    public AbstractSQLQuery(Connection conn, SQLTemplates templates) {
        super((QueryMetadata)new DefaultQueryMetadata());
        this.conn = conn;
        this.templates = templates;
    }

    public List<Object[]> list(Expr<?> expr1, Expr<?> expr2, Expr<?> ... rest) {
        this.addToProjection(new Expr[]{expr1, expr2});
        this.addToProjection(rest);
        try {
            return this.listMultiple();
        }
        catch (SQLException e) {
            String error = "Caught " + e.getClass().getName();
            logger.error(error, (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object[]> listMultiple() throws SQLException {
        String queryString = this.toString();
        logger.debug("query : {}", (Object)queryString);
        PreparedStatement stmt = this.conn.prepareStatement(queryString);
        int counter = 1;
        for (Object o : this.constants) {
            try {
                this.set(stmt, counter++, o);
            }
            catch (Exception e) {
                String error = "Caught " + e.getClass().getName();
                logger.error(error, (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        ResultSet rs = stmt.executeQuery();
        try {
            ArrayList<Object[]> rv = new ArrayList<Object[]>();
            while (rs.next()) {
                Object[] objects = new Object[rs.getMetaData().getColumnCount()];
                for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                    objects[i] = rs.getObject(i + 1);
                }
                rv.add(objects);
            }
            ArrayList<Object[]> arrayList = rv;
            return arrayList;
        }
        finally {
            try {
                rs.close();
            }
            finally {
                stmt.close();
            }
        }
    }

    public <RT> List<RT> list(Expr<RT> expr) {
        this.addToProjection(new Expr[]{expr});
        try {
            return this.listSingle(expr);
        }
        catch (SQLException e) {
            String error = "Caught " + e.getClass().getName();
            logger.error(error, (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <RT> SearchResults<RT> listResults(Expr<RT> expr) {
        this.addToProjection(new Expr[]{expr});
        long total = this.count();
        if (total > 0L) {
            QueryModifiers modifiers = this.getMetadata().getModifiers();
            return new SearchResults(this.list(expr), modifiers, total);
        }
        return SearchResults.emptyResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <RT> List<RT> listSingle(Expr<RT> expr) throws SQLException {
        String queryString = this.toString();
        logger.debug("query : {}", (Object)queryString);
        PreparedStatement stmt = this.conn.prepareStatement(queryString);
        int counter = 1;
        for (Object o : this.constants) {
            try {
                this.set(stmt, counter++, o);
            }
            catch (Exception e) {
                String error = "Caught " + e.getClass().getName();
                logger.error(error, (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        ResultSet rs = stmt.executeQuery();
        try {
            ArrayList<Object> rv = new ArrayList<Object>();
            if (expr instanceof EConstructor) {
                EConstructor c = (EConstructor)expr;
                Constructor cc = c.getJavaConstructor();
                while (rs.next()) {
                    try {
                        ArrayList args = new ArrayList();
                        for (int i = 0; i < c.getArgs().size(); ++i) {
                            args.add(this.get(rs, i + 1, c.getArg(i).getType()));
                        }
                        rv.add(cc.newInstance(args.toArray()));
                    }
                    catch (Exception e) {
                        String error = "Caught " + e.getClass().getName();
                        logger.error(error, (Throwable)e);
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            } else {
                while (rs.next()) {
                    rv.add(rs.getObject(1));
                }
            }
            ArrayList<Object> arrayList = rv;
            return arrayList;
        }
        finally {
            try {
                rs.close();
            }
            finally {
                stmt.close();
            }
        }
    }

    private <T> T get(ResultSet rs, int i, Class<T> type) throws Exception {
        String methodName = "get" + type.getSimpleName();
        if (methodName.equals("getInteger")) {
            methodName = "getInt";
        }
        return (T)ResultSet.class.getMethod(methodName, Integer.TYPE).invoke((Object)rs, i);
    }

    private void set(PreparedStatement stmt, int i, Object o) throws Exception {
        Class<Date> type = o.getClass();
        String methodName = "set" + type.getSimpleName();
        if (methodName.equals("setInteger")) {
            methodName = "setInt";
        }
        Class<Date> clazz = type = ClassUtils.wrapperToPrimitive(type) != null ? ClassUtils.wrapperToPrimitive(type) : type;
        if (methodName.equals("setDate") && type.equals(java.util.Date.class)) {
            type = Date.class;
            o = new Date(((java.util.Date)o).getTime());
        }
        PreparedStatement.class.getMethod(methodName, Integer.TYPE, type).invoke((Object)stmt, i, o);
    }

    public String toString() {
        if (this.queryString == null) {
            this.queryString = this.buildQueryString(false);
        }
        return this.queryString;
    }

    public <RT> UnionBuilder<RT> union(ObjectSubQuery<RT> ... sq) {
        return this.innerUnion((SubQuery[])sq);
    }

    public <RT> UnionBuilder<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQuery[])sq);
    }

    private <RT> UnionBuilder<RT> innerUnion(SubQuery ... sq) {
        if (!this.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.sq = sq;
        return new UnionBuilder();
    }

    protected SQLSerializer createSerializer() {
        return new SQLSerializer(this.templates);
    }

    protected String buildQueryString(boolean forCountRow) {
        SQLSerializer serializer = this.createSerializer();
        if (this.sq != null) {
            serializer.serializeUnion(this.sq, this.getMetadata().getOrderBy());
        } else {
            serializer.serialize(this.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstants();
        return serializer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long unsafeCount() throws SQLException {
        String queryString = this.buildQueryString(true);
        logger.debug("query : {}", (Object)queryString);
        System.out.println(queryString);
        PreparedStatement stmt = this.conn.prepareStatement(queryString);
        ResultSet rs = null;
        try {
            long rv;
            int counter = 1;
            for (Object o : this.constants) {
                try {
                    this.set(stmt, counter++, o);
                }
                catch (Exception e) {
                    String error = "Caught " + e.getClass().getName();
                    logger.error(error, (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            rs = stmt.executeQuery();
            rs.next();
            long l = rv = rs.getLong(1);
            return l;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
    }

    public long count() {
        try {
            return this.unsafeCount();
        }
        catch (SQLException e) {
            String error = "Caught " + e.getClass().getName();
            logger.error(error, (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Iterator<Object[]> iterate(Expr<?> e1, Expr<?> e2, Expr<?> ... rest) {
        return this.list(e1, e2, rest).iterator();
    }

    public <RT> Iterator<RT> iterate(Expr<RT> projection) {
        return this.list(projection).iterator();
    }

    public <RT> RT uniqueResult(Expr<RT> expr) {
        List<RT> list = this.list(expr);
        return !list.isEmpty() ? (RT)list.get(0) : null;
    }

    public SubType from(PEntity<?> ... o) {
        return (SubType)((Object)((AbstractSQLQuery)super.from(o)));
    }

    public SubType fullJoin(Expr<?> o) {
        this.getMetadata().addJoin(JoinType.FULLJOIN, o);
        return (SubType)((Object)((AbstractSQLQuery)this._this));
    }

    public SubType innerJoin(Expr<?> o) {
        this.getMetadata().addJoin(JoinType.INNERJOIN, o);
        return (SubType)((Object)((AbstractSQLQuery)this._this));
    }

    public SubType join(Expr<?> o) {
        this.getMetadata().addJoin(JoinType.JOIN, o);
        return (SubType)((Object)((AbstractSQLQuery)this._this));
    }

    public SubType leftJoin(Expr<?> o) {
        this.getMetadata().addJoin(JoinType.LEFTJOIN, o);
        return (SubType)((Object)((AbstractSQLQuery)this._this));
    }

    public SubType on(EBoolean condition) {
        this.getMetadata().addJoinCondition(condition);
        return (SubType)((Object)((AbstractSQLQuery)this._this));
    }

    public class UnionBuilder<RT>
    implements Union<RT> {
        @Override
        public UnionBuilder<RT> orderBy(OrderSpecifier<?> ... o) {
            AbstractSQLQuery.this.orderBy(o);
            return this;
        }

        @Override
        public List<RT> list() throws SQLException {
            if (AbstractSQLQuery.this.sq[0].getMetadata().getProjection().size() == 1) {
                return AbstractSQLQuery.this.listSingle(null);
            }
            return AbstractSQLQuery.this.listMultiple();
        }
    }
}

