/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.codegen;

import com.mysema.query.codegen.EntityType;
import com.mysema.query.sql.codegen.AbstractNamingStrategy;
import com.mysema.query.sql.codegen.Naming;
import java.util.Locale;

public class DefaultNamingStrategy
extends AbstractNamingStrategy {
    public DefaultNamingStrategy() {
        this.reservedSuffix = "Col";
    }

    @Override
    public String getClassName(String tableName) {
        if (tableName.length() > 1) {
            return tableName.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.toCamelCase(tableName.substring(1));
        }
        return tableName.toUpperCase(Locale.ENGLISH);
    }

    @Override
    public String getDefaultAlias(EntityType entityType) {
        return entityType.getData().get("table").toString();
    }

    @Override
    public String getDefaultVariableName(EntityType entityType) {
        return this.escape(entityType, this.toCamelCase(entityType.getData().get("table").toString()));
    }

    @Override
    public String getForeignKeysVariable(EntityType entityType) {
        return this.escape(entityType, this.foreignKeysVariable);
    }

    @Override
    public String getPrimaryKeysVariable(EntityType entityType) {
        return this.escape(entityType, this.primaryKeysVariable);
    }

    @Override
    public String getPropertyName(String columnName, EntityType entityType) {
        if (columnName.length() > 1) {
            String normalized = this.normalizePropertyName(columnName);
            return this.normalizePropertyName(normalized.substring(0, 1).toLowerCase(Locale.ENGLISH) + this.toCamelCase(normalized.substring(1)));
        }
        return columnName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String getPropertyNameForForeignKey(String fkName, EntityType entityType) {
        if (fkName.toLowerCase().startsWith("fk_")) {
            fkName = fkName.substring(3) + "_" + fkName.substring(0, 2);
        }
        return this.getPropertyName(fkName, entityType);
    }

    @Override
    public String getPropertyNameForInverseForeignKey(String fkName, EntityType entityType) {
        return "_" + this.getPropertyNameForForeignKey(fkName, entityType);
    }

    @Override
    public String getPropertyNameForPrimaryKey(String pkName, EntityType entityType) {
        if (pkName.toLowerCase().startsWith("pk_")) {
            pkName = pkName.substring(3) + "_" + pkName.substring(0, 2);
        }
        return this.getPropertyName(pkName, entityType);
    }

    @Override
    public String normalizeColumnName(String columnName) {
        return columnName.replaceAll("\r", "").replaceAll("\n", " ");
    }

    @Override
    public String normalizeTableName(String tableName) {
        return tableName.replaceAll("\r", "").replaceAll("\n", " ");
    }

    @Override
    public String normalizeSchemaName(String schemaName) {
        return schemaName.replaceAll("\r", "").replaceAll("\n", " ");
    }

    protected String normalizePropertyName(String name) {
        return Naming.normalize(name, this.reservedSuffix);
    }

    protected String toCamelCase(String str) {
        boolean toLower = str.toUpperCase().equals(str);
        StringBuilder builder = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (i < str.length() - 1 && (str.charAt(i) == '_' || str.charAt(i) == ' ')) {
                if (++i >= str.length()) continue;
                builder.append(Character.toUpperCase(str.charAt(i)));
                continue;
            }
            if (toLower) {
                builder.append(Character.toLowerCase(str.charAt(i)));
                continue;
            }
            builder.append(str.charAt(i));
        }
        return builder.toString();
    }
}

