/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.codegen;

import com.mysema.query.codegen.EntityType;
import com.mysema.query.sql.codegen.NamingStrategy;
import com.mysema.util.JavaSyntaxUtils;

public abstract class AbstractNamingStrategy
implements NamingStrategy {
    protected String foreignKeysClassName = "ForeignKeys";
    protected String foreignKeysVariable = "fk";
    protected String primaryKeysClassName = "PrimaryKeys";
    protected String primaryKeysVariable = "pk";
    protected String reservedSuffix = "_col";

    @Override
    public String appendSchema(String packageName, String schemaName) {
        String suffix = schemaName.toLowerCase();
        if (JavaSyntaxUtils.isReserved((String)suffix)) {
            suffix = suffix + "_";
        }
        return packageName + "." + suffix;
    }

    protected String escape(EntityType entityType, String name) {
        String candidate;
        int suffix = 0;
        while (true) {
            String string = candidate = suffix > 0 ? name + suffix : name;
            if (!entityType.getEscapedPropertyNames().contains(candidate)) break;
            ++suffix;
        }
        return candidate;
    }

    @Override
    public String getForeignKeysClassName() {
        return this.foreignKeysClassName;
    }

    @Override
    public String getForeignKeysVariable(EntityType entityType) {
        return this.foreignKeysVariable;
    }

    @Override
    public String getPrimaryKeysClassName() {
        return this.primaryKeysClassName;
    }

    @Override
    public String getPrimaryKeysVariable(EntityType entityType) {
        return this.primaryKeysVariable;
    }

    public void setForeignKeysClassName(String foreignKeysClassName) {
        this.foreignKeysClassName = foreignKeysClassName;
    }

    public void setForeignKeysVariable(String foreignKeysVariable) {
        this.foreignKeysVariable = foreignKeysVariable;
    }

    public void setPrimaryKeysClassName(String primaryKeysClassName) {
        this.primaryKeysClassName = primaryKeysClassName;
    }

    public void setPrimaryKeysVariable(String primaryKeysVariable) {
        this.primaryKeysVariable = primaryKeysVariable;
    }

    public void setReservedSuffix(String reservedSuffix) {
        this.reservedSuffix = reservedSuffix;
    }
}

