/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.ant;

import com.mysema.query.codegen.BeanSerializer;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.sql.codegen.DefaultNamingStrategy;
import com.mysema.query.sql.codegen.MetaDataExporter;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntMetaDataExporter
extends Task {
    private String jdbcDriverClass;
    private String dbUrl;
    private String dbUserName;
    private String dbPassword;
    private String namePrefix;
    private String nameSuffix;
    private String beanPrefix;
    private String beanSuffix;
    private String targetPackage;
    private String beanTargetPackage;
    private String targetSourceFolder;
    private String schemaPattern;
    private String tableNamePattern;
    private boolean innerClassesForKeys;
    private boolean exportBeans;
    private boolean validationAnnotations = false;
    private String sourceEncoding;
    private boolean columnAnnotations = false;
    private boolean schemaToPackage = false;
    private boolean lowerCase = false;
    private boolean exportTables = true;
    private boolean exportViews = true;
    private boolean exportAll = false;
    private boolean exportPrimaryKeys = true;
    private boolean exportForeignKeys = true;
    private String[] beanInterfaces;
    private boolean beanAddToString;
    private boolean beanAddFullConstructor;
    private boolean beanPrintSupertype;
    private String[] imports;

    public void execute() {
        Connection dbConn = null;
        File targetPackagePath = new File(this.targetSourceFolder);
        try {
            Class.forName(this.jdbcDriverClass).newInstance();
            dbConn = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);
            DefaultNamingStrategy namingStrategy = new DefaultNamingStrategy();
            MetaDataExporter exporter = new MetaDataExporter();
            if (this.namePrefix != null) {
                exporter.setNamePrefix(this.namePrefix);
            }
            if (this.nameSuffix != null) {
                exporter.setNameSuffix(this.nameSuffix);
            }
            if (this.beanPrefix != null) {
                exporter.setBeanPrefix(this.beanPrefix);
            }
            if (this.beanSuffix != null) {
                exporter.setBeanSuffix(this.beanSuffix);
            }
            exporter.setPackageName(this.targetPackage);
            exporter.setBeanPackageName(this.beanTargetPackage);
            exporter.setTargetFolder(targetPackagePath);
            exporter.setNamingStrategy(namingStrategy);
            exporter.setInnerClassesForKeys(this.innerClassesForKeys);
            exporter.setSchemaPattern(this.schemaPattern);
            exporter.setTableNamePattern(this.tableNamePattern);
            exporter.setColumnAnnotations(this.columnAnnotations);
            exporter.setValidationAnnotations(this.validationAnnotations);
            exporter.setSchemaToPackage(this.schemaToPackage);
            exporter.setLowerCase(this.lowerCase);
            exporter.setExportTables(this.exportTables);
            exporter.setExportViews(this.exportViews);
            exporter.setExportAll(this.exportAll);
            exporter.setExportPrimaryKeys(this.exportPrimaryKeys);
            exporter.setExportForeignKeys(this.exportForeignKeys);
            if (this.imports != null && this.imports.length > 0) {
                exporter.setImports(this.imports);
            }
            if (this.exportBeans) {
                BeanSerializer serializer = new BeanSerializer();
                if (this.beanInterfaces != null) {
                    for (String iface : this.beanInterfaces) {
                        try {
                            serializer.addInterface(Class.forName(iface));
                        }
                        catch (ClassNotFoundException e) {
                            throw new BuildException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                serializer.setAddFullConstructor(this.beanAddFullConstructor);
                serializer.setAddToString(this.beanAddToString);
                serializer.setPrintSupertype(this.beanPrintSupertype);
                exporter.setBeanSerializer((Serializer)serializer);
            }
            if (this.sourceEncoding != null) {
                exporter.setSourceEncoding(this.sourceEncoding);
            }
            exporter.export(dbConn.getMetaData());
        }
        catch (RuntimeException e) {
            throw new BuildException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException e2) {
                    throw new BuildException((Throwable)e2);
                }
            }
        }
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public void setDbUserName(String dbUserName) {
        this.dbUserName = dbUserName;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public void setJdbcDriverClass(String jdbcDriverClass) {
        this.jdbcDriverClass = jdbcDriverClass;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public String getTargetSourceFolder() {
        return this.targetSourceFolder;
    }

    public void setTargetSourceFolder(String targetSourceFolder) {
        this.targetSourceFolder = targetSourceFolder;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public boolean isInnerClassesForKeys() {
        return this.innerClassesForKeys;
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.innerClassesForKeys = innerClassesForKeys;
    }

    public boolean isExportBeans() {
        return this.exportBeans;
    }

    public void setExportBeans(boolean exportBeans) {
        this.exportBeans = exportBeans;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public String getBeanPrefix() {
        return this.beanPrefix;
    }

    public void setBeanPrefix(String beanPrefix) {
        this.beanPrefix = beanPrefix;
    }

    public String getBeanSuffix() {
        return this.beanSuffix;
    }

    public void setBeanSuffix(String beanSuffix) {
        this.beanSuffix = beanSuffix;
    }

    public String getBeanTargetPackage() {
        return this.beanTargetPackage;
    }

    public void setBeanTargetPackage(String beanTargetPackage) {
        this.beanTargetPackage = beanTargetPackage;
    }

    public boolean isValidationAnnotations() {
        return this.validationAnnotations;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public boolean isColumnAnnotations() {
        return this.columnAnnotations;
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public boolean isSchemaToPackage() {
        return this.schemaToPackage;
    }

    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public boolean isExportTables() {
        return this.exportTables;
    }

    public void setExportTables(boolean exportTables) {
        this.exportTables = exportTables;
    }

    public boolean isExportViews() {
        return this.exportViews;
    }

    public void setExportViews(boolean exportViews) {
        this.exportViews = exportViews;
    }

    public boolean isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    public boolean isExportPrimaryKeys() {
        return this.exportPrimaryKeys;
    }

    public void setExportPrimaryKeys(boolean exportPrimaryKeys) {
        this.exportPrimaryKeys = exportPrimaryKeys;
    }

    public boolean isExportForeignKeys() {
        return this.exportForeignKeys;
    }

    public void setExportForeignKeys(boolean exportForeignKeys) {
        this.exportForeignKeys = exportForeignKeys;
    }

    public String[] getImports() {
        return this.imports;
    }

    public void setImports(String[] imports) {
        this.imports = imports;
    }
}

