/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.maven;

import com.mysema.query.codegen.Serializer;
import com.mysema.query.sql.DefaultNamingStrategy;
import com.mysema.query.sql.MetaDataExporter;
import com.mysema.query.sql.MetaDataSerializer;
import com.mysema.query.sql.NamingStrategy;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class AbstractMetaDataExportMojo
extends AbstractMojo {
    private MavenProject project;
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String namePrefix;
    private String packageName;
    private String schemaPattern;
    private String tableNamePattern;
    private String targetFolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isForTest()) {
            this.project.addTestCompileSourceRoot(this.targetFolder);
        } else {
            this.project.addCompileSourceRoot(this.targetFolder);
        }
        DefaultNamingStrategy namingStrategy = new DefaultNamingStrategy();
        MetaDataSerializer serializer = new MetaDataSerializer(this.namePrefix, (NamingStrategy)namingStrategy);
        MetaDataExporter exporter = new MetaDataExporter(this.namePrefix, this.packageName, this.schemaPattern, this.tableNamePattern, new File(this.targetFolder), (NamingStrategy)namingStrategy, (Serializer)serializer, null);
        try {
            Class.forName(this.jdbcDriver);
            Connection conn = DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
            try {
                exporter.export(conn.getMetaData());
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected boolean isForTest() {
        return false;
    }
}

